/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.java;

import io.camunda.connector.generator.api.ElementTemplateGenerator;
import io.camunda.connector.generator.api.GeneratorConfiguration;
import io.camunda.connector.generator.dsl.BpmnType;
import io.camunda.connector.generator.dsl.ElementTemplateBuilder;
import io.camunda.connector.generator.dsl.ElementTemplateIcon;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyGroup;
import io.camunda.connector.generator.java.annotation.ElementTemplate;
import io.camunda.connector.generator.java.util.ReflectionUtil;
import io.camunda.connector.generator.java.util.TemplateGenerationContext;
import io.camunda.connector.generator.java.util.TemplateGenerationContextUtil;
import io.camunda.connector.generator.java.util.TemplateGenerationStringUtil;
import io.camunda.connector.generator.java.util.TemplatePropertiesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ClassBasedTemplateGenerator
implements ElementTemplateGenerator<Class<?>> {
    private final ClassLoader classLoader;

    public ClassBasedTemplateGenerator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassBasedTemplateGenerator() {
        this(Thread.currentThread().getContextClassLoader());
    }

    @Override
    public List<io.camunda.connector.generator.dsl.ElementTemplate> generate(Class<?> connectorDefinition, GeneratorConfiguration configuration) {
        ElementTemplate template = ReflectionUtil.getRequiredAnnotation(connectorDefinition, ElementTemplate.class);
        Class<?> connectorInput = template.inputDataClass();
        TemplateGenerationContext context = TemplateGenerationContextUtil.createContext(connectorDefinition, configuration);
        List<PropertyBuilder> properties = TemplatePropertiesUtil.extractTemplatePropertiesFromType(connectorInput, context);
        ArrayList<PropertyGroup.PropertyGroupBuilder> groupsDefinedInProperties = new ArrayList<PropertyGroup.PropertyGroupBuilder>(TemplatePropertiesUtil.groupProperties(properties));
        List<ElementTemplate.PropertyGroup> manuallyDefinedGroups = Arrays.asList(template.propertyGroups());
        ArrayList<PropertyGroup> mergedGroups = new ArrayList<PropertyGroup>();
        if (!manuallyDefinedGroups.isEmpty()) {
            for (ElementTemplate.PropertyGroup group : manuallyDefinedGroups) {
                Optional<PropertyGroup.PropertyGroupBuilder> groupDefinedInProperties = groupsDefinedInProperties.stream().filter(g -> g.build().id().equals(group.id())).findFirst();
                if (groupDefinedInProperties.isEmpty()) {
                    throw new IllegalStateException(String.format("Property group '%s' defined in @ElementTemplate but no properties with this group id found", group.id()));
                }
                mergedGroups.add(PropertyGroup.builder().id(group.id()).label(group.label()).properties(groupDefinedInProperties.get().build().properties()).build());
            }
        } else {
            mergedGroups.addAll(new ArrayList<PropertyGroup>(groupsDefinedInProperties.stream().map(PropertyGroup.PropertyGroupBuilder::build).toList()));
        }
        if (groupsDefinedInProperties.isEmpty()) {
            mergedGroups.add(PropertyGroup.builder().id("default").label("Properties").properties((PropertyBuilder[])properties.toArray(PropertyBuilder[]::new)).build());
        }
        List<PropertyBuilder> nonGroupedProperties = properties.stream().filter(property -> property.build().getGroup() == null).toList();
        ElementTemplateIcon icon = template.icon().isBlank() ? null : ElementTemplateIcon.from(template.icon(), this.classLoader);
        return context.elementTypes().stream().map(elementType -> {
            ElementTemplateBuilder builder = context instanceof TemplateGenerationContext.Outbound ? ElementTemplateBuilder.createOutbound() : ElementTemplateBuilder.createInbound();
            return builder.id(ClassBasedTemplateGenerator.createId(context, template.id(), elementType)).type(context.connectorType(), GeneratorConfiguration.ConnectorMode.HYBRID.equals((Object)configuration.connectorMode())).name(ClassBasedTemplateGenerator.createName(context, template.name(), elementType)).version(template.version()).appliesTo(elementType.appliesTo()).elementType(elementType.elementType()).icon(icon).documentationRef(template.documentationRef().isEmpty() ? null : template.documentationRef()).description(template.description().isEmpty() ? null : template.description()).properties(nonGroupedProperties.stream().map(PropertyBuilder::build).toList()).propertyGroups(this.addServiceProperties((List<PropertyGroup>)mergedGroups, context, (GeneratorConfiguration.ConnectorElementType)elementType)).build();
        }).toList();
    }

    private static String createId(TemplateGenerationContext context, String templateId, GeneratorConfiguration.ConnectorElementType elementType) {
        return Optional.ofNullable(elementType.templateIdOverride()).orElseGet(() -> context.elementTypes().size() > 1 ? templateId + ":" + elementType.elementType().getId() : templateId);
    }

    private static String createName(TemplateGenerationContext context, String templateName, GeneratorConfiguration.ConnectorElementType elementType) {
        return Optional.ofNullable(elementType.templateNameOverride()).orElseGet(() -> {
            if (context.elementTypes().size() > 1) {
                return templateName + " (" + TemplateGenerationStringUtil.camelCaseToSpaces(elementType.elementType().getId()) + ")";
            }
            return templateName;
        });
    }

    private List<PropertyGroup> addServiceProperties(List<PropertyGroup> groups, TemplateGenerationContext context, GeneratorConfiguration.ConnectorElementType elementType) {
        ArrayList<PropertyGroup> newGroups = new ArrayList<PropertyGroup>(groups);
        if (context instanceof TemplateGenerationContext.Outbound) {
            newGroups.add(PropertyGroup.OUTPUT_GROUP_OUTBOUND);
            newGroups.add(PropertyGroup.ERROR_GROUP);
            newGroups.add(PropertyGroup.RETRIES_GROUP);
        } else {
            newGroups.add(PropertyGroup.ACTIVATION_GROUP);
            if (elementType.elementType().equals((Object)BpmnType.MESSAGE_START_EVENT)) {
                newGroups.add(PropertyGroup.CORRELATION_GROUP_MESSAGE_START_EVENT);
            } else if (elementType.elementType().equals((Object)BpmnType.INTERMEDIATE_CATCH_EVENT) || elementType.elementType().equals((Object)BpmnType.BOUNDARY_EVENT)) {
                newGroups.add(PropertyGroup.CORRELATION_GROUP_INTERMEDIATE_CATCH_EVENT_OR_BOUNDARY);
            }
            newGroups.add(PropertyGroup.OUTPUT_GROUP_INBOUND);
        }
        return newGroups;
    }
}

