/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb.model;

import connector.com.fasterxml.jackson.core.JsonParser;
import connector.com.fasterxml.jackson.core.JsonProcessingException;
import connector.com.fasterxml.jackson.databind.DeserializationContext;
import connector.com.fasterxml.jackson.databind.JsonDeserializer;
import connector.com.fasterxml.jackson.databind.JsonNode;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.aws.dynamodb.model.AddItem;
import io.camunda.connector.aws.dynamodb.model.AwsInput;
import io.camunda.connector.aws.dynamodb.model.CreateTable;
import io.camunda.connector.aws.dynamodb.model.DeleteItem;
import io.camunda.connector.aws.dynamodb.model.DeleteTable;
import io.camunda.connector.aws.dynamodb.model.DescribeTable;
import io.camunda.connector.aws.dynamodb.model.GetItem;
import io.camunda.connector.aws.dynamodb.model.ScanTable;
import io.camunda.connector.aws.dynamodb.model.UpdateItem;
import java.io.IOException;

public class AwsInputDeserializer
extends JsonDeserializer<AwsInput> {
    @Override
    public AwsInput deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String operationType = this.determineActionType(node);
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        return switch (operationType) {
            case "createTable" -> mapper.convertValue((Object)node, CreateTable.class);
            case "deleteTable" -> mapper.convertValue((Object)node, DeleteTable.class);
            case "describeTable" -> mapper.convertValue((Object)node, DescribeTable.class);
            case "scanTable" -> mapper.convertValue((Object)node, ScanTable.class);
            case "addItem" -> mapper.convertValue((Object)node, AddItem.class);
            case "deleteItem" -> mapper.convertValue((Object)node, DeleteItem.class);
            case "getItem" -> mapper.convertValue((Object)node, GetItem.class);
            case "updateItem" -> mapper.convertValue((Object)node, UpdateItem.class);
            default -> throw new UnsupportedOperationException("Unsupported action type: " + operationType);
        };
    }

    private String determineActionType(JsonNode node) {
        if (node.has("tableOperation")) {
            return node.get("tableOperation").asText();
        }
        if (node.has("itemOperation")) {
            return node.get("itemOperation").asText();
        }
        if (node.has("type")) {
            return node.get("type").asText();
        }
        throw new UnsupportedOperationException("Unsupported operation type");
    }
}

