/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers;

import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BooleanSetUnmarshaller
implements ArgumentUnmarshaller {
    private static final BooleanSetUnmarshaller INSTANCE = new BooleanSetUnmarshaller();

    public static BooleanSetUnmarshaller instance() {
        return INSTANCE;
    }

    private BooleanSetUnmarshaller() {
    }

    @Override
    public void typeCheck(AttributeValue value, Method setter2) {
        if (value.getNS() == null && value.getL() == null) {
            throw new DynamoDBMappingException("Expected either L or NS in value " + value + " when invoking " + setter2);
        }
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        if (value.getL() != null) {
            return this.unmarshallList(value.getL());
        }
        return this.unmarshallNS(value.getNS());
    }

    private Set<Boolean> unmarshallList(List<AttributeValue> values) {
        HashSet<Boolean> result = new HashSet<Boolean>();
        for (AttributeValue value : values) {
            Boolean bool;
            if (Boolean.TRUE.equals(value.isNULL())) {
                bool = null;
            } else {
                bool = value.getBOOL();
                if (bool == null) {
                    throw new DynamoDBMappingException(value + " is not a boolean");
                }
            }
            if (result.add(bool)) continue;
            throw new DynamoDBMappingException("Duplicate value (" + bool + ") found in " + values);
        }
        return result;
    }

    private Set<Boolean> unmarshallNS(List<String> values) {
        HashSet<Boolean> result = new HashSet<Boolean>();
        for (String s : values) {
            if ("1".equals(s)) {
                result.add(Boolean.TRUE);
                continue;
            }
            if ("0".equals(s)) {
                result.add(Boolean.FALSE);
                continue;
            }
            throw new IllegalArgumentException("Expected '1' or '0' for boolean value, was " + s);
        }
        return result;
    }
}

