/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.java.util;

import io.camunda.connector.api.annotation.InboundConnector;
import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.generator.api.GeneratorConfiguration;
import io.camunda.connector.generator.dsl.BpmnType;
import io.camunda.connector.generator.java.annotation.ElementTemplate;
import io.camunda.connector.generator.java.util.ConfigurationUtil;
import io.camunda.connector.generator.java.util.ReflectionUtil;
import io.camunda.connector.generator.java.util.TemplateGenerationContext;
import java.util.Set;

public class TemplateGenerationContextUtil {
    private static final Set<BpmnType> OUTBOUND_SUPPORTED_ELEMENT_TYPES = Set.of(BpmnType.SERVICE_TASK, BpmnType.INTERMEDIATE_THROW_EVENT, BpmnType.SCRIPT_TASK, BpmnType.MESSAGE_END_EVENT);
    private static final Set<BpmnType> INBOUND_SUPPORTED_ELEMENT_TYPES = Set.of(BpmnType.START_EVENT, BpmnType.INTERMEDIATE_CATCH_EVENT, BpmnType.MESSAGE_START_EVENT, BpmnType.BOUNDARY_EVENT);
    private static final GeneratorConfiguration.ConnectorElementType OUTBOUND_DEFAULT_ELEMENT_TYPE = new GeneratorConfiguration.ConnectorElementType(Set.of(BpmnType.TASK), BpmnType.SERVICE_TASK, null, null);
    private static final Set<GeneratorConfiguration.ConnectorElementType> INBOUND_DEFAULT_ELEMENT_TYPES = Set.of(new GeneratorConfiguration.ConnectorElementType(Set.of(BpmnType.START_EVENT), BpmnType.START_EVENT, null, null), new GeneratorConfiguration.ConnectorElementType(Set.of(BpmnType.INTERMEDIATE_CATCH_EVENT, BpmnType.INTERMEDIATE_THROW_EVENT), BpmnType.INTERMEDIATE_CATCH_EVENT, null, null), new GeneratorConfiguration.ConnectorElementType(Set.of(BpmnType.MESSAGE_START_EVENT), BpmnType.MESSAGE_START_EVENT, null, null), new GeneratorConfiguration.ConnectorElementType(Set.of(BpmnType.BOUNDARY_EVENT), BpmnType.BOUNDARY_EVENT, null, null));

    public static TemplateGenerationContext createContext(Class<?> connectorDefinition, GeneratorConfiguration configuration) {
        OutboundConnector outboundAnnotation = connectorDefinition.getAnnotation(OutboundConnector.class);
        InboundConnector inboundAnnotation = connectorDefinition.getAnnotation(InboundConnector.class);
        if (outboundAnnotation != null && inboundAnnotation != null) {
            throw new IllegalArgumentException("Connector definition must be annotated with either @InboundConnector or @OutboundConnector, not both");
        }
        if (outboundAnnotation != null) {
            return TemplateGenerationContextUtil.createOutboundContext(connectorDefinition, configuration, outboundAnnotation);
        }
        return TemplateGenerationContextUtil.createInboundContext(connectorDefinition, configuration, inboundAnnotation);
    }

    private static TemplateGenerationContext.Outbound createOutboundContext(Class<?> connectorDefinition, GeneratorConfiguration configuration, OutboundConnector connector) {
        ElementTemplate template = ReflectionUtil.getRequiredAnnotation(connectorDefinition, ElementTemplate.class);
        GeneratorConfiguration mergedConfig = ConfigurationUtil.fromAnnotation(template, configuration);
        Set<GeneratorConfiguration.ConnectorElementType> elementTypes = mergedConfig.elementTypes();
        if (elementTypes.isEmpty()) {
            elementTypes = Set.of(OUTBOUND_DEFAULT_ELEMENT_TYPE);
        }
        elementTypes.stream().filter(t -> !OUTBOUND_SUPPORTED_ELEMENT_TYPES.contains((Object)t.elementType())).findFirst().ifPresent(t -> {
            throw new IllegalArgumentException("Unsupported element type " + String.valueOf((Object)t.elementType()) + " for outbound connector");
        });
        return new TemplateGenerationContext.Outbound(connector.type(), elementTypes);
    }

    private static TemplateGenerationContext.Inbound createInboundContext(Class<?> connectorDefinition, GeneratorConfiguration configuration, InboundConnector connector) {
        ElementTemplate template = ReflectionUtil.getRequiredAnnotation(connectorDefinition, ElementTemplate.class);
        GeneratorConfiguration mergedConfig = ConfigurationUtil.fromAnnotation(template, configuration);
        Set<GeneratorConfiguration.ConnectorElementType> elementTypes = mergedConfig.elementTypes();
        if (elementTypes.isEmpty()) {
            elementTypes = INBOUND_DEFAULT_ELEMENT_TYPES;
        }
        elementTypes.stream().filter(t -> !INBOUND_SUPPORTED_ELEMENT_TYPES.contains((Object)t.elementType())).findFirst().ifPresent(t -> {
            throw new IllegalArgumentException("Unsupported element type " + String.valueOf((Object)t.elementType()) + " for inbound connector");
        });
        return new TemplateGenerationContext.Inbound(connector.type(), elementTypes);
    }
}

