/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb;

import io.camunda.connector.aws.dynamodb.model.AddItem;
import io.camunda.connector.aws.dynamodb.model.AwsInput;
import io.camunda.connector.aws.dynamodb.model.CreateTable;
import io.camunda.connector.aws.dynamodb.model.DeleteItem;
import io.camunda.connector.aws.dynamodb.model.DeleteTable;
import io.camunda.connector.aws.dynamodb.model.DescribeTable;
import io.camunda.connector.aws.dynamodb.model.GetItem;
import io.camunda.connector.aws.dynamodb.model.ScanTable;
import io.camunda.connector.aws.dynamodb.model.UpdateItem;
import io.camunda.connector.aws.dynamodb.operation.AwsDynamoDbOperation;
import io.camunda.connector.aws.dynamodb.operation.item.AddItemOperation;
import io.camunda.connector.aws.dynamodb.operation.item.DeleteItemOperation;
import io.camunda.connector.aws.dynamodb.operation.item.GetItemOperation;
import io.camunda.connector.aws.dynamodb.operation.item.UpdateItemOperation;
import io.camunda.connector.aws.dynamodb.operation.table.CreateTableOperation;
import io.camunda.connector.aws.dynamodb.operation.table.DeleteTableOperation;
import io.camunda.connector.aws.dynamodb.operation.table.DescribeTableOperation;
import io.camunda.connector.aws.dynamodb.operation.table.ScanTableOperation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class AwsDynamoDbOperationFactory {
    private static final AwsDynamoDbOperationFactory instance = new AwsDynamoDbOperationFactory();

    private AwsDynamoDbOperationFactory() {
    }

    public static AwsDynamoDbOperationFactory getInstance() {
        return instance;
    }

    public AwsDynamoDbOperation createOperation(AwsInput input) {
        AwsInput awsInput = input;
        Objects.requireNonNull(awsInput);
        AwsInput awsInput2 = awsInput;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AddItem.class, CreateTable.class, DeleteItem.class, DeleteTable.class, DescribeTable.class, GetItem.class, ScanTable.class, UpdateItem.class}, (Object)awsInput2, n)) {
            case 0 -> {
                AddItem addItem = (AddItem)awsInput2;
                yield new AddItemOperation(addItem);
            }
            case 1 -> {
                CreateTable createTable = (CreateTable)awsInput2;
                yield new CreateTableOperation(createTable);
            }
            case 2 -> {
                DeleteItem deleteItem = (DeleteItem)awsInput2;
                yield new DeleteItemOperation(deleteItem);
            }
            case 3 -> {
                DeleteTable deleteTable = (DeleteTable)awsInput2;
                yield new DeleteTableOperation(deleteTable);
            }
            case 4 -> {
                DescribeTable describeTable = (DescribeTable)awsInput2;
                yield new DescribeTableOperation(describeTable);
            }
            case 5 -> {
                GetItem getItem = (GetItem)awsInput2;
                yield new GetItemOperation(getItem);
            }
            case 6 -> {
                ScanTable scanTable = (ScanTable)awsInput2;
                yield new ScanTableOperation(scanTable);
            }
            case 7 -> {
                UpdateItem updateItem = (UpdateItem)awsInput2;
                yield new UpdateItemOperation(updateItem);
            }
            default -> throw new UnsupportedOperationException("Unsupported operation: [" + input.getClass().getSimpleName() + "]");
        };
    }
}

