/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.java.util;

import connector.com.fasterxml.jackson.databind.JsonNode;
import io.camunda.connector.generator.dsl.BooleanProperty;
import io.camunda.connector.generator.dsl.DropdownProperty;
import io.camunda.connector.generator.dsl.HiddenProperty;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBinding;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyCondition;
import io.camunda.connector.generator.dsl.PropertyGroup;
import io.camunda.connector.generator.dsl.StringProperty;
import io.camunda.connector.generator.dsl.TextProperty;
import io.camunda.connector.generator.java.annotation.NestedProperties;
import io.camunda.connector.generator.java.annotation.TemplateDiscriminatorProperty;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.generator.java.annotation.TemplateSubType;
import io.camunda.connector.generator.java.processor.FieldProcessor;
import io.camunda.connector.generator.java.processor.JakartaValidationFieldProcessor;
import io.camunda.connector.generator.java.processor.TemplatePropertyFieldProcessor;
import io.camunda.connector.generator.java.util.DiscriminatorPropertyBuilder;
import io.camunda.connector.generator.java.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;

public class TemplatePropertiesUtil {
    private static final List<FieldProcessor> fieldProcessors = List.of(new TemplatePropertyFieldProcessor(), new JakartaValidationFieldProcessor());

    public static List<PropertyBuilder> extractTemplatePropertiesFromType(Class<?> type) {
        if (type.isSealed()) {
            return TemplatePropertiesUtil.handleSealedType(type);
        }
        List<Field> fields = ReflectionUtil.getAllFields(type);
        ArrayList<PropertyBuilder> properties = new ArrayList<PropertyBuilder>();
        for (Field field2 : fields) {
            if (TemplatePropertiesUtil.isContainerType(field2.getType())) {
                NestedProperties nestedPropertiesAnnotation = field2.getAnnotation(NestedProperties.class);
                List<PropertyBuilder> nestedProperties = TemplatePropertiesUtil.extractTemplatePropertiesFromType(field2.getType()).stream().peek(builder -> {
                    if (nestedPropertiesAnnotation == null || nestedPropertiesAnnotation.addNestedPath()) {
                        TemplatePropertiesUtil.addPathPrefix(builder, field2.getName());
                    }
                }).peek(builder -> {
                    if (nestedPropertiesAnnotation != null && nestedPropertiesAnnotation.condition() != null) {
                        builder.condition(TemplatePropertyFieldProcessor.transformToCondition(nestedPropertiesAnnotation.condition()));
                    }
                }).peek(builder -> {
                    if (nestedPropertiesAnnotation != null && !nestedPropertiesAnnotation.group().isBlank()) {
                        builder.group(nestedPropertiesAnnotation.group());
                    }
                }).toList();
                properties.addAll(nestedProperties);
                continue;
            }
            properties.add(TemplatePropertiesUtil.buildProperty(field2));
        }
        return properties.stream().filter(Objects::nonNull).toList();
    }

    public static List<PropertyGroup.PropertyGroupBuilder> groupProperties(List<PropertyBuilder> properties) {
        return properties.stream().map(PropertyBuilder::build).filter(property -> property.getGroup() != null).collect(Collectors.groupingBy(Property::getGroup)).entrySet().stream().map(entry -> PropertyGroup.builder().id((String)entry.getKey()).label(TemplatePropertiesUtil.transformIdIntoLabel((String)entry.getKey())).properties((List)entry.getValue())).toList();
    }

    private static PropertyBuilder buildProperty(Field field2) {
        String label;
        String name;
        String fieldName;
        TemplateProperty annotation = field2.getAnnotation(TemplateProperty.class);
        String bindingName = fieldName = field2.getName();
        if (annotation != null) {
            if (annotation.ignore()) {
                return null;
            }
            name = !annotation.id().isBlank() ? annotation.id() : field2.getName();
            label = !annotation.label().isBlank() ? annotation.label() : TemplatePropertiesUtil.transformIdIntoLabel(name);
            if (!annotation.binding().name().isBlank()) {
                bindingName = annotation.binding().name();
            }
        } else {
            name = field2.getName();
            label = TemplatePropertiesUtil.transformIdIntoLabel(name);
        }
        PropertyBuilder propertyBuilder = TemplatePropertiesUtil.createPropertyBuilder(field2, annotation).id(name).label(label).binding(TemplatePropertiesUtil.createBinding(bindingName));
        for (FieldProcessor processor : fieldProcessors) {
            processor.process(field2, propertyBuilder);
        }
        return propertyBuilder;
    }

    private static PropertyBuilder addPathPrefix(PropertyBuilder builder, String path) {
        String originalId = builder.getId();
        builder.id(path + "." + originalId);
        PropertyBinding binding = builder.getBinding();
        if (binding instanceof PropertyBinding.ZeebeInput) {
            builder.binding(TemplatePropertiesUtil.createBinding(path + "." + ((PropertyBinding.ZeebeInput)binding).name()));
        }
        if (builder instanceof DiscriminatorPropertyBuilder) {
            DiscriminatorPropertyBuilder discriminatorPropertyBuilder = (DiscriminatorPropertyBuilder)builder;
            discriminatorPropertyBuilder.getDependantProperties().forEach(dependant -> dependant.condition(TemplatePropertiesUtil.addConditionPrefix(dependant.getCondition(), path, originalId)));
        }
        return builder;
    }

    private static PropertyCondition addConditionPrefix(PropertyCondition condition, String path, String discriminatorPropertyId) {
        if (condition instanceof PropertyCondition.AllMatch) {
            PropertyCondition.AllMatch allMatchCondition = (PropertyCondition.AllMatch)condition;
            return new PropertyCondition.AllMatch(allMatchCondition.allMatch().stream().map(subCondition -> TemplatePropertiesUtil.addConditionPrefix(subCondition, path, discriminatorPropertyId)).toList());
        }
        if (condition instanceof PropertyCondition.Equals) {
            PropertyCondition.Equals equalsCondition = (PropertyCondition.Equals)condition;
            if (!equalsCondition.property().equals(discriminatorPropertyId)) {
                return equalsCondition;
            }
            return new PropertyCondition.Equals(path + "." + equalsCondition.property(), equalsCondition.equals());
        }
        if (condition instanceof PropertyCondition.OneOf) {
            PropertyCondition.OneOf oneOfCondition = (PropertyCondition.OneOf)condition;
            if (!oneOfCondition.property().equals(discriminatorPropertyId)) {
                return oneOfCondition;
            }
            return new PropertyCondition.OneOf(path + "." + oneOfCondition.property(), oneOfCondition.oneOf());
        }
        throw new IllegalStateException("Unknown condition type: " + String.valueOf(condition.getClass()));
    }

    private static PropertyBuilder createPropertyBuilder(Field field2, TemplateProperty annotation) {
        TemplateProperty.PropertyType type;
        Map<Object, Object> dropdownChoices = new HashMap();
        if (field2.getType() == Boolean.class) {
            type = TemplateProperty.PropertyType.Boolean;
        } else if (field2.getType().isEnum()) {
            type = TemplateProperty.PropertyType.Dropdown;
            dropdownChoices = Arrays.stream(field2.getType().getEnumConstants()).collect(Collectors.toMap(Object::toString, val -> TemplatePropertiesUtil.transformIdIntoLabel(val.toString())));
        } else {
            type = TemplateProperty.PropertyType.String;
        }
        if (annotation != null) {
            if (annotation.type() != TemplateProperty.PropertyType.Unknown) {
                type = annotation.type();
            }
            if (annotation.choices().length > 0) {
                dropdownChoices = Arrays.stream(annotation.choices()).collect(Collectors.toMap(TemplateProperty.DropdownPropertyChoice::value, TemplateProperty.DropdownPropertyChoice::label));
            }
        }
        PropertyBuilder builder = switch (type) {
            default -> throw new MatchException(null, null);
            case TemplateProperty.PropertyType.Boolean -> BooleanProperty.builder();
            case TemplateProperty.PropertyType.Dropdown -> DropdownProperty.builder().choices(dropdownChoices.entrySet().stream().map(entry -> new DropdownProperty.DropdownChoice((String)entry.getValue(), (String)entry.getKey())).toList()).feel(Property.FeelMode.disabled);
            case TemplateProperty.PropertyType.Hidden -> HiddenProperty.builder();
            case TemplateProperty.PropertyType.String -> StringProperty.builder();
            case TemplateProperty.PropertyType.Text -> TextProperty.builder();
            case TemplateProperty.PropertyType.Unknown -> throw new IllegalStateException("Unknown property type");
        };
        if (Object.class.equals(field2.getType()) || JsonNode.class.equals(field2.getType()) || Collection.class.isAssignableFrom(field2.getType()) || Map.class.isAssignableFrom(field2.getType())) {
            builder.feel(Property.FeelMode.required);
        }
        return builder;
    }

    private static List<PropertyBuilder> handleSealedType(Class<?> type) {
        List<Class> subTypes = Arrays.stream(type.getPermittedSubclasses()).filter(subType -> {
            TemplateSubType annotation = subType.getAnnotation(TemplateSubType.class);
            return annotation == null || !annotation.ignore();
        }).toList();
        ArrayList<PropertyBuilder> properties = new ArrayList<PropertyBuilder>();
        Map.Entry<String, String> discriminatorIdAndName = TemplatePropertiesUtil.extractIdAndLabelFromAnnotationOrDeriveFromType(type, TemplateDiscriminatorProperty.class, TemplateDiscriminatorProperty::name, TemplateDiscriminatorProperty::label);
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (Class subType2 : subTypes) {
            Map.Entry<String, String> subTypeIdAndName = TemplatePropertiesUtil.extractIdAndLabelFromAnnotationOrDeriveFromType(subType2, TemplateSubType.class, TemplateSubType::id, TemplateSubType::label);
            values.put(subTypeIdAndName.getKey(), subTypeIdAndName.getValue());
            List<PropertyBuilder> currentSubTypeProperties = TemplatePropertiesUtil.extractTemplatePropertiesFromType(subType2).stream().peek(property -> {
                if (property.getCondition() == null) {
                    PropertyCondition.Equals condition = new PropertyCondition.Equals((String)discriminatorIdAndName.getKey(), (String)subTypeIdAndName.getKey());
                    property.condition(condition);
                } else {
                    PropertyCondition patt0$temp = property.getCondition();
                    if (patt0$temp instanceof PropertyCondition.AllMatch) {
                        PropertyCondition.AllMatch allMatch = (PropertyCondition.AllMatch)patt0$temp;
                        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>(allMatch.allMatch());
                        conditions.add(new PropertyCondition.Equals((String)discriminatorIdAndName.getKey(), (String)subTypeIdAndName.getKey()));
                        property.condition(new PropertyCondition.AllMatch(conditions));
                    } else {
                        property.condition(new PropertyCondition.AllMatch(List.of(property.getCondition(), new PropertyCondition.Equals((String)discriminatorIdAndName.getKey(), (String)subTypeIdAndName.getKey()))));
                    }
                }
            }).toList();
            properties.addAll(currentSubTypeProperties);
        }
        if (values.isEmpty()) {
            throw new IllegalStateException("Sealed type " + String.valueOf(type) + " has no subtypes");
        }
        TemplateDiscriminatorProperty discriminatorAnnotation = type.getAnnotation(TemplateDiscriminatorProperty.class);
        PropertyBuilder discriminator = new DiscriminatorPropertyBuilder().dependantProperties(properties).choices(values.entrySet().stream().filter(Objects::nonNull).map(entry -> new DropdownProperty.DropdownChoice((String)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList())).id(discriminatorIdAndName.getKey()).binding(TemplatePropertiesUtil.createBinding(discriminatorIdAndName.getKey())).group(discriminatorAnnotation == null || discriminatorAnnotation.group().isBlank() ? null : discriminatorAnnotation.group()).label(discriminatorIdAndName.getValue()).description(discriminatorAnnotation == null || discriminatorAnnotation.description().isBlank() ? null : discriminatorAnnotation.description()).value(discriminatorAnnotation == null || discriminatorAnnotation.defaultValue().isBlank() ? null : discriminatorAnnotation.defaultValue());
        ArrayList<PropertyBuilder> result = new ArrayList<PropertyBuilder>(List.of(discriminator));
        result.addAll(properties);
        return result;
    }

    private static <T extends Annotation> Map.Entry<String, String> extractIdAndLabelFromAnnotationOrDeriveFromType(Class<?> type, Class<T> annotationClass, Function<T, String> idExtractor, Function<T, String> labelExtractor) {
        T annotation = type.getAnnotation(annotationClass);
        if (annotation != null) {
            String id = idExtractor.apply(annotation);
            String name = labelExtractor.apply(annotation);
            if (name.isBlank()) {
                name = TemplatePropertiesUtil.transformIdIntoLabel(type.getSimpleName());
            }
            return Map.entry(id, name);
        }
        return Map.entry(type.getSimpleName().toLowerCase(), TemplatePropertiesUtil.transformIdIntoLabel(type.getSimpleName()));
    }

    public static String transformIdIntoLabel(String id) {
        if (id.toUpperCase().equals(id)) {
            return id;
        }
        StringBuilder label = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (i == 0) {
                label.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isUpperCase(c) || Character.isDigit(c) && !Character.isDigit(id.charAt(i - 1))) {
                label.append(" ").append(Character.toLowerCase(c));
                continue;
            }
            label.append(c);
        }
        return label.toString();
    }

    private static boolean isContainerType(Class<?> type) {
        return !ClassUtils.isPrimitiveOrWrapper(type) && !type.isAssignableFrom(String.class) && type != Object.class && type != JsonNode.class && !type.isEnum() && !type.isArray() && !Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type);
    }

    private static PropertyBinding createBinding(String propertyName) {
        return new PropertyBinding.ZeebeInput(propertyName);
    }
}

