/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.java.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionUtil {
    public static <T extends Annotation> T getRequiredAnnotation(Class<?> clazz, Class<T> annotationClass) {
        return ReflectionUtil.getRequiredAnnotation(clazz, annotationClass, "Annotation " + annotationClass.getName() + " is required on " + String.valueOf(clazz));
    }

    public static <T extends Annotation> T getRequiredAnnotation(Class<?> clazz, Class<T> annotationClass, String errorMessage) {
        T annotation = clazz.getAnnotation(annotationClass);
        if (annotation == null) {
            throw new IllegalStateException(errorMessage);
        }
        return annotation;
    }

    public static List<Field> getAllFields(Class<?> type) {
        return ReflectionUtil.getAllFields(new ArrayList<Field>(), type);
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            ReflectionUtil.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }
}

