/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.java;

import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.generator.api.ElementTemplateGenerator;
import io.camunda.connector.generator.api.GeneratorConfiguration;
import io.camunda.connector.generator.dsl.BpmnType;
import io.camunda.connector.generator.dsl.ElementTemplateIcon;
import io.camunda.connector.generator.dsl.OutboundElementTemplate;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyGroup;
import io.camunda.connector.generator.java.annotation.ElementTemplate;
import io.camunda.connector.generator.java.util.ConfigurationUtil;
import io.camunda.connector.generator.java.util.ReflectionUtil;
import io.camunda.connector.generator.java.util.TemplatePropertiesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class OutboundClassBasedTemplateGenerator
implements ElementTemplateGenerator<Class<?>, OutboundElementTemplate> {
    private static final Set<BpmnType> SUPPORTED_ELEMENT_TYPES = Set.of(BpmnType.SERVICE_TASK, BpmnType.INTERMEDIATE_THROW_EVENT, BpmnType.SCRIPT_TASK, BpmnType.MESSAGE_END_EVENT);
    private static final GeneratorConfiguration.ConnectorElementType DEFAULT_ELEMENT_TYPE = new GeneratorConfiguration.ConnectorElementType(Set.of(BpmnType.TASK), BpmnType.SERVICE_TASK);
    private final ClassLoader classLoader;

    public OutboundClassBasedTemplateGenerator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public OutboundClassBasedTemplateGenerator() {
        this(Thread.currentThread().getContextClassLoader());
    }

    @Override
    public List<OutboundElementTemplate> generate(Class<?> connectorDefinition, GeneratorConfiguration configuration) {
        OutboundConnector connector = ReflectionUtil.getRequiredAnnotation(connectorDefinition, OutboundConnector.class);
        ElementTemplate template = ReflectionUtil.getRequiredAnnotation(connectorDefinition, ElementTemplate.class);
        Class<?> connectorInput = template.inputDataClass();
        GeneratorConfiguration mergedConfig = ConfigurationUtil.fromAnnotation(template, configuration);
        Set<GeneratorConfiguration.ConnectorElementType> elementTypes = mergedConfig.elementTypes();
        if (elementTypes.isEmpty()) {
            elementTypes = Set.of(DEFAULT_ELEMENT_TYPE);
        }
        elementTypes.stream().filter(t -> !SUPPORTED_ELEMENT_TYPES.contains((Object)t.elementType())).findFirst().ifPresent(t -> {
            throw new IllegalArgumentException(String.format("Unsupported element type '%s'", t.elementType().getName()));
        });
        List<PropertyBuilder> properties = TemplatePropertiesUtil.extractTemplatePropertiesFromType(connectorInput);
        ArrayList<PropertyGroup.PropertyGroupBuilder> groupsDefinedInProperties = new ArrayList<PropertyGroup.PropertyGroupBuilder>(TemplatePropertiesUtil.groupProperties(properties));
        List<ElementTemplate.PropertyGroup> manuallyDefinedGroups = Arrays.asList(template.propertyGroups());
        ArrayList<PropertyGroup> mergedGroups = new ArrayList<PropertyGroup>();
        if (!manuallyDefinedGroups.isEmpty()) {
            for (ElementTemplate.PropertyGroup group : manuallyDefinedGroups) {
                Optional<PropertyGroup.PropertyGroupBuilder> groupDefinedInProperties = groupsDefinedInProperties.stream().filter(g -> g.build().id().equals(group.id())).findFirst();
                if (groupDefinedInProperties.isEmpty()) {
                    throw new IllegalStateException(String.format("Property group '%s' defined in @ElementTemplate but no properties with this group id found", group.id()));
                }
                mergedGroups.add(PropertyGroup.builder().id(group.id()).label(group.label()).properties(groupDefinedInProperties.get().build().properties()).build());
            }
        } else {
            mergedGroups.addAll(new ArrayList<PropertyGroup>(groupsDefinedInProperties.stream().map(PropertyGroup.PropertyGroupBuilder::build).toList()));
        }
        if (groupsDefinedInProperties.isEmpty()) {
            mergedGroups.add(PropertyGroup.builder().id("default").label("Properties").properties((PropertyBuilder[])properties.toArray(PropertyBuilder[]::new)).build());
        }
        mergedGroups.add(PropertyGroup.OUTPUT_GROUP);
        mergedGroups.add(PropertyGroup.ERROR_GROUP);
        mergedGroups.add(PropertyGroup.RETRIES_GROUP);
        List<PropertyBuilder> nonGroupedProperties = properties.stream().filter(property -> property.build().getGroup() == null).toList();
        ElementTemplateIcon icon = template.icon().isBlank() ? null : ElementTemplateIcon.from(template.icon(), this.classLoader);
        return elementTypes.stream().map(elementType -> OutboundElementTemplate.builder().id(template.id()).type(connector.type(), GeneratorConfiguration.ConnectorMode.HYBRID.equals((Object)configuration.connectorMode())).name(template.name()).version(template.version()).appliesTo(elementType.appliesTo()).elementType(elementType.elementType()).icon(icon).documentationRef(template.documentationRef().isEmpty() ? null : template.documentationRef()).description(template.description().isEmpty() ? null : template.description()).properties(nonGroupedProperties.stream().map(PropertyBuilder::build).toList()).propertyGroups(mergedGroups).build()).toList();
    }
}

