/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import connector.com.fasterxml.jackson.annotation.JsonValue;

public enum BpmnType {
    TASK("bpmn:Task"),
    SERVICE_TASK("bpmn:ServiceTask"),
    RECEIVE_TASK("bpmn:ReceiveTask"),
    SCRIPT_TASK("bpmn:ScriptTask"),
    START_EVENT("bpmn:StartEvent"),
    INTERMEDIATE_CATCH_EVENT("bpmn:IntermediateCatchEvent"),
    INTERMEDIATE_THROW_EVENT("bpmn:IntermediateThrowEvent"),
    MESSAGE_START_EVENT("bpmn:MessageStartEvent"),
    END_EVENT("bpmn:EndEvent"),
    MESSAGE_END_EVENT("bpmn:MessageEndEvent");

    private final String name;

    private BpmnType(String name) {
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public static BpmnType fromName(String name) {
        for (BpmnType type : BpmnType.values()) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown BPMN type: " + name);
    }
}

