/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb.operation.item;

import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.UpdateItemOutcome;
import com.amazonaws.services.dynamodbv2.document.spec.UpdateItemSpec;
import com.amazonaws.services.dynamodbv2.document.utils.ValueMap;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import connector.com.fasterxml.jackson.core.type.TypeReference;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.aws.ObjectMapperSupplier;
import io.camunda.connector.aws.dynamodb.model.UpdateItem;
import io.camunda.connector.aws.dynamodb.operation.AwsDynamoDbOperation;
import java.util.Map;

public class UpdateItemOperation
implements AwsDynamoDbOperation {
    private static final String ACTION_PUT = "put";
    private static final String ACTION_DELETE = "delete";
    private static final String UPDATE_EXPRESSION_SET = "set ";
    private static final String UPDATE_EXPRESSION_REMOVE = "remove ";
    private final UpdateItem updateItemModel;
    private final ObjectMapper objectMapper;

    public UpdateItemOperation(UpdateItem updateItemModel) {
        this.updateItemModel = updateItemModel;
        this.objectMapper = ObjectMapperSupplier.getMapperInstance();
    }

    @Override
    public Object invoke(DynamoDB dynamoDB) {
        Map<String, Object> primaryKeyMap = this.objectMapper.convertValue(this.updateItemModel.primaryKeyComponents(), new TypeReference<Map<String, Object>>(this){});
        Map<String, Object> attributesMap = this.objectMapper.convertValue(this.updateItemModel.keyAttributes(), new TypeReference<Map<String, Object>>(this){});
        String tableName = this.updateItemModel.tableName();
        String action = this.updateItemModel.attributeAction();
        return this.updateItem(dynamoDB, primaryKeyMap, attributesMap, action, tableName);
    }

    private UpdateItemOutcome updateItem(DynamoDB dynamoDB, Map<String, Object> primaryKeyMap, Map<String, Object> attributesMap, String action, String tableName) {
        try {
            Table table = dynamoDB.getTable(tableName);
            PrimaryKey primaryKey = this.buildPrimaryKey(primaryKeyMap);
            UpdateItemSpec updateItemSpec = this.buildUpdateItemSpec(primaryKey, attributesMap, action);
            return table.updateItem(updateItemSpec);
        }
        catch (Exception e) {
            throw new ConnectorException("Error in updateItem operation: " + e.getMessage(), (Throwable)e);
        }
    }

    private PrimaryKey buildPrimaryKey(Map<String, Object> primaryKeyMap) {
        PrimaryKey primaryKey = new PrimaryKey();
        primaryKeyMap.forEach(primaryKey::addComponent);
        return primaryKey;
    }

    private UpdateItemSpec buildUpdateItemSpec(PrimaryKey primaryKey, Map<String, Object> attributesMap, String action) {
        UpdateItemSpec updateItemSpec = new UpdateItemSpec().withPrimaryKey(primaryKey);
        ValueMap valueMap = new ValueMap();
        StringBuilder updateExpression = new StringBuilder();
        if (ACTION_PUT.equalsIgnoreCase(action)) {
            this.buildPutUpdateExpression(attributesMap, updateExpression, valueMap);
        } else if (ACTION_DELETE.equalsIgnoreCase(action)) {
            this.buildDeleteUpdateExpression(attributesMap, updateExpression);
        } else {
            throw new ConnectorException("Invalid action: " + action);
        }
        updateItemSpec.withUpdateExpression(updateExpression.toString()).withReturnValues(ReturnValue.ALL_NEW);
        if (!valueMap.isEmpty()) {
            updateItemSpec.withValueMap(valueMap);
        }
        return updateItemSpec;
    }

    private void buildPutUpdateExpression(Map<String, Object> attributesMap, StringBuilder updateExpression, ValueMap valueMap) {
        updateExpression.append(UPDATE_EXPRESSION_SET);
        attributesMap.forEach((k, v) -> {
            String attrKey = ":" + k;
            updateExpression.append((String)k).append(" = ").append(attrKey).append(", ");
            valueMap.withString(attrKey, String.valueOf(v));
        });
        this.trimTrailingComma(updateExpression);
    }

    private void buildDeleteUpdateExpression(Map<String, Object> attributesMap, StringBuilder updateExpression) {
        updateExpression.append(UPDATE_EXPRESSION_REMOVE);
        attributesMap.keySet().forEach(k -> updateExpression.append((String)k).append(", "));
        this.trimTrailingComma(updateExpression);
    }

    private void trimTrailingComma(StringBuilder updateExpression) {
        if (!updateExpression.isEmpty()) {
            updateExpression.setLength(updateExpression.length() - 2);
        }
    }
}

