/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb.operation.item;

import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import connector.com.fasterxml.jackson.core.type.TypeReference;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.aws.ObjectMapperSupplier;
import io.camunda.connector.aws.dynamodb.model.GetItem;
import io.camunda.connector.aws.dynamodb.operation.AwsDynamoDbOperation;
import java.util.HashMap;
import java.util.Optional;

public class GetItemOperation
implements AwsDynamoDbOperation {
    private final GetItem getItemModel;
    private final ObjectMapper objectMapper;

    public GetItemOperation(GetItem getItemModel) {
        this.getItemModel = getItemModel;
        this.objectMapper = ObjectMapperSupplier.getMapperInstance();
    }

    @Override
    public Object invoke(DynamoDB dynamoDB) {
        return Optional.ofNullable(dynamoDB.getTable(this.getItemModel.tableName()).getItem(this.createPrimaryKey())).map(Item::attributes).orElse(null);
    }

    private PrimaryKey createPrimaryKey() {
        PrimaryKey primaryKey = new PrimaryKey();
        this.objectMapper.convertValue(this.getItemModel.primaryKeyComponents(), new TypeReference<HashMap<String, Object>>(this){}).forEach(primaryKey::addComponent);
        return primaryKey;
    }
}

