/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import connector.com.fasterxml.jackson.annotation.JsonIgnore;
import connector.com.fasterxml.jackson.annotation.JsonProperty;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public record PropertyGroup(@JsonProperty String id, @JsonProperty String label, @JsonIgnore List<Property> properties) {
    public PropertyGroup {
        if (id == null) {
            throw new IllegalArgumentException("id is required");
        }
        if (label == null) {
            throw new IllegalArgumentException("label is required");
        }
        if (properties == null) {
            properties = Collections.emptyList();
        }
    }

    public static PropertyGroupBuilder builder() {
        return new PropertyGroupBuilder();
    }

    public static final class PropertyGroupBuilder {
        private String id;
        private String label;
        private final List<Property> properties = new ArrayList<Property>();

        private PropertyGroupBuilder() {
        }

        public PropertyGroupBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PropertyGroupBuilder label(String label) {
            this.label = label;
            return this;
        }

        public PropertyGroupBuilder properties(PropertyBuilder ... properties) {
            this.requireIdSet();
            this.properties.addAll(Stream.of(properties).map(builder -> builder.group(this.id)).map(PropertyBuilder::build).toList());
            return this;
        }

        public PropertyGroupBuilder properties(List<Property> properties) {
            this.requireIdSet();
            properties.forEach(property -> {
                if (!this.id.equals(property.group)) {
                    throw new IllegalArgumentException("Property " + property.id + " defines a different group " + property.group + " than the group " + this.id + " it is added to");
                }
            });
            this.properties.addAll(properties);
            return this;
        }

        public PropertyGroupBuilder properties(Property ... properties) {
            return this.properties(List.of(properties));
        }

        public PropertyGroup build() {
            return new PropertyGroup(this.id, this.label, this.properties);
        }

        private void requireIdSet() {
            if (this.id == null) {
                throw new IllegalStateException("id is required before properties can be set");
            }
        }
    }
}

