/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import connector.com.fasterxml.jackson.annotation.JsonInclude;
import connector.com.fasterxml.jackson.annotation.JsonProperty;
import connector.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.connector.generator.dsl.ElementTemplateBase;
import io.camunda.connector.generator.dsl.ElementTemplateCategory;
import io.camunda.connector.generator.dsl.ElementTemplateIcon;
import io.camunda.connector.generator.dsl.OutboundElementTemplateBuilder;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonPropertyOrder(value={"$schema", "name", "id", "description", "documentationRef", "version", "category", "appliesTo", "elementType", "groups", "properties"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record OutboundElementTemplate(@JsonProperty String id, @JsonProperty String name, @JsonProperty int version, @JsonProperty String documentationRef, @JsonProperty String description, @JsonProperty Set<String> appliesTo, @JsonProperty ElementType elementType, @JsonProperty List<PropertyGroup> groups, @JsonProperty List<Property> properties, @JsonProperty ElementTemplateIcon icon) implements ElementTemplateBase
{
    public OutboundElementTemplate {
        ArrayList<Object> errors = new ArrayList<Object>();
        if (id == null) {
            errors.add("id is required");
        }
        if (name == null) {
            errors.add("name is required");
        }
        if (version < 0) {
            errors.add("version cannot be negative");
        }
        if (appliesTo == null || appliesTo.isEmpty() || appliesTo.stream().allMatch(String::isBlank)) {
            errors.add("appliesTo must be defined");
        }
        if (elementType == null || elementType.value == null || elementType.value.isBlank()) {
            errors.add("elementType must be defined");
        }
        if (groups == null) {
            errors.add("groups is required");
        }
        if (properties == null) {
            errors.add("properties is required");
        } else {
            HashSet<String> propIdOccurrences = new HashSet<String>();
            for (Property property : properties) {
                if (property.id == null) continue;
                if (propIdOccurrences.contains(property.id)) {
                    errors.add("duplicate property " + property.id);
                }
                propIdOccurrences.add(property.id);
            }
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(String.join((CharSequence)", ", errors));
        }
        if (icon != null && !icon.contents().matches("^(data):.*")) {
            throw new IllegalArgumentException("icon contents must be base64 encoded");
        }
    }

    @JsonProperty
    public ElementTemplateCategory category() {
        return ElementTemplateCategory.CONNECTORS;
    }

    public static OutboundElementTemplateBuilder builder() {
        return OutboundElementTemplateBuilder.create();
    }

    public record ElementType(@JsonProperty String value) {
    }
}

