/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb.operation.item;

import com.amazonaws.services.dynamodbv2.document.AttributeUpdate;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import connector.com.fasterxml.jackson.core.type.TypeReference;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.aws.ObjectMapperSupplier;
import io.camunda.connector.aws.dynamodb.model.UpdateItem;
import io.camunda.connector.aws.dynamodb.operation.AwsDynamoDbOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class UpdateItemOperation
implements AwsDynamoDbOperation {
    private final UpdateItem updateItemModel;
    private final ObjectMapper objectMapper;

    public UpdateItemOperation(UpdateItem updateItemModel) {
        this.updateItemModel = updateItemModel;
        this.objectMapper = ObjectMapperSupplier.getMapperInstance();
    }

    @Override
    public Object invoke(DynamoDB dynamoDB) {
        PrimaryKey primaryKey = new PrimaryKey();
        this.objectMapper.convertValue(this.updateItemModel.getKeyAttributes(), new TypeReference<HashMap<String, Object>>(){}).forEach(primaryKey::addComponent);
        return dynamoDB.getTable(this.updateItemModel.getTableName()).updateItem(primaryKey, this.getAttributeUpdatesArray());
    }

    private AttributeUpdate[] getAttributeUpdatesArray() {
        ArrayList attributeUpdates = new ArrayList();
        this.objectMapper.convertValue(this.updateItemModel.getKeyAttributes(), new TypeReference<HashMap<String, Object>>(){}).forEach((key, value) -> {
            AttributeAction attributeAction = AttributeAction.fromValue(this.updateItemModel.getAttributeAction().toUpperCase(Locale.ROOT));
            AttributeUpdate attributeUpdate = switch (attributeAction) {
                case AttributeAction.PUT -> new AttributeUpdate((String)key).put(value);
                case AttributeAction.DELETE -> new AttributeUpdate((String)key).delete();
                default -> throw new IllegalArgumentException("Unsupported action [" + attributeAction + "]");
            };
            attributeUpdates.add(attributeUpdate);
        });
        return (AttributeUpdate[])attributeUpdates.toArray(AttributeUpdate[]::new);
    }
}

