/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb.operation.item;

import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import connector.com.fasterxml.jackson.core.type.TypeReference;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.aws.ObjectMapperSupplier;
import io.camunda.connector.aws.dynamodb.model.DeleteItem;
import io.camunda.connector.aws.dynamodb.operation.AwsDynamoDbOperation;
import java.util.ArrayList;
import java.util.HashMap;

public class DeleteItemOperation
implements AwsDynamoDbOperation {
    private final DeleteItem deleteItemModel;
    private final ObjectMapper objectMapper;

    public DeleteItemOperation(DeleteItem deleteItemModel) {
        this.deleteItemModel = deleteItemModel;
        this.objectMapper = ObjectMapperSupplier.getMapperInstance();
    }

    @Override
    public Object invoke(DynamoDB dynamoDb) {
        return dynamoDb.getTable(this.deleteItemModel.getTableName()).deleteItem(this.createKeyAttributes());
    }

    private KeyAttribute[] createKeyAttributes() {
        ArrayList keyAttributeList = new ArrayList();
        this.objectMapper.convertValue(this.deleteItemModel.getPrimaryKeyComponents(), new TypeReference<HashMap<String, Object>>(){}).forEach((key, value) -> keyAttributeList.add(new KeyAttribute((String)key, value)));
        return (KeyAttribute[])keyAttributeList.toArray(KeyAttribute[]::new);
    }
}

