/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb;

import io.camunda.connector.aws.dynamodb.model.AddItem;
import io.camunda.connector.aws.dynamodb.model.AwsInput;
import io.camunda.connector.aws.dynamodb.model.CreateTable;
import io.camunda.connector.aws.dynamodb.model.DeleteItem;
import io.camunda.connector.aws.dynamodb.model.DeleteTable;
import io.camunda.connector.aws.dynamodb.model.DescribeTable;
import io.camunda.connector.aws.dynamodb.model.GetItem;
import io.camunda.connector.aws.dynamodb.model.ScanTable;
import io.camunda.connector.aws.dynamodb.model.UpdateItem;
import io.camunda.connector.aws.dynamodb.operation.AwsDynamoDbOperation;
import io.camunda.connector.aws.dynamodb.operation.item.AddItemOperation;
import io.camunda.connector.aws.dynamodb.operation.item.DeleteItemOperation;
import io.camunda.connector.aws.dynamodb.operation.item.GetItemOperation;
import io.camunda.connector.aws.dynamodb.operation.item.UpdateItemOperation;
import io.camunda.connector.aws.dynamodb.operation.table.CreateTableOperation;
import io.camunda.connector.aws.dynamodb.operation.table.DeleteTableOperation;
import io.camunda.connector.aws.dynamodb.operation.table.DescribeTableOperation;
import io.camunda.connector.aws.dynamodb.operation.table.ScanTableOperation;

public class AwsDynamoDbOperationFactory {
    private static final AwsDynamoDbOperationFactory instance = new AwsDynamoDbOperationFactory();

    private AwsDynamoDbOperationFactory() {
    }

    public static AwsDynamoDbOperationFactory getInstance() {
        return instance;
    }

    public AwsDynamoDbOperation createOperation(AwsInput input) {
        if (input instanceof AddItem) {
            return new AddItemOperation((AddItem)input);
        }
        if (input instanceof CreateTable) {
            return new CreateTableOperation((CreateTable)input);
        }
        if (input instanceof DeleteItem) {
            return new DeleteItemOperation((DeleteItem)input);
        }
        if (input instanceof DeleteTable) {
            return new DeleteTableOperation((DeleteTable)input);
        }
        if (input instanceof DescribeTable) {
            return new DescribeTableOperation((DescribeTable)input);
        }
        if (input instanceof GetItem) {
            return new GetItemOperation((GetItem)input);
        }
        if (input instanceof ScanTable) {
            return new ScanTableOperation((ScanTable)input);
        }
        if (input instanceof UpdateItem) {
            return new UpdateItemOperation((UpdateItem)input);
        }
        throw new UnsupportedOperationException("Unsupported operation : [" + input.getClass() + "]");
    }
}

