/*
 * Decompiled with CFR 0.152.
 */
package connector.com.fasterxml.jackson.module.scala.deser;

import connector.com.fasterxml.jackson.core.JsonParser;
import connector.com.fasterxml.jackson.databind.DeserializationContext;
import connector.com.fasterxml.jackson.databind.DeserializationFeature;
import connector.com.fasterxml.jackson.databind.JavaType;
import connector.com.fasterxml.jackson.databind.JsonDeserializer;
import connector.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import connector.com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import connector.com.fasterxml.jackson.databind.type.TypeFactory;
import scala.collection.Map;
import scala.collection.Seq;

public class UntypedScalaObjectDeserializer
extends UntypedObjectDeserializer {
    private JsonDeserializer<Object> _mapDeser;
    private JsonDeserializer<Object> _listDeser;

    public UntypedScalaObjectDeserializer() {
        super(null, null);
    }

    @Override
    public void resolve(DeserializationContext ctxt) {
        super.resolve(ctxt);
        JavaType anyRef = ctxt.constructType(Object.class);
        JavaType string2 = ctxt.constructType(String.class);
        DeserializerFactory factory = ctxt.getFactory();
        TypeFactory tf = ctxt.getTypeFactory();
        this._mapDeser = ctxt.findRootValueDeserializer(factory.mapAbstractType(ctxt.getConfig(), tf.constructMapLikeType(Map.class, string2, anyRef)));
        this._listDeser = ctxt.findRootValueDeserializer(factory.mapAbstractType(ctxt.getConfig(), tf.constructCollectionLikeType(Seq.class, anyRef)));
    }

    @Override
    public Object mapArray(JsonParser jp, DeserializationContext ctxt) {
        if (ctxt.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
            return this.mapArrayToArray(jp, ctxt);
        }
        return this._listDeser.deserialize(jp, ctxt);
    }

    @Override
    public Object mapObject(JsonParser jp, DeserializationContext ctxt) {
        return this._mapDeser.deserialize(jp, ctxt);
    }
}

