/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.java;

import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.generator.api.ElementTemplateGenerator;
import io.camunda.connector.generator.api.GeneratorConfiguration;
import io.camunda.connector.generator.dsl.BpmnType;
import io.camunda.connector.generator.dsl.CommonProperties;
import io.camunda.connector.generator.dsl.ElementTemplateIcon;
import io.camunda.connector.generator.dsl.OutboundElementTemplate;
import io.camunda.connector.generator.dsl.PropertyBinding;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyGroup;
import io.camunda.connector.generator.java.annotation.ElementTemplate;
import io.camunda.connector.generator.java.util.ReflectionUtil;
import io.camunda.connector.generator.java.util.TemplatePropertiesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class OutboundClassBasedTemplateGenerator
implements ElementTemplateGenerator<Class<?>, OutboundElementTemplate> {
    private final ClassLoader classLoader;

    public OutboundClassBasedTemplateGenerator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public OutboundClassBasedTemplateGenerator() {
        this(Thread.currentThread().getContextClassLoader());
    }

    @Override
    public OutboundElementTemplate generate(Class<?> connectorDefinition, GeneratorConfiguration configuration) {
        String elementType;
        OutboundConnector connector = ReflectionUtil.getRequiredAnnotation(connectorDefinition, OutboundConnector.class);
        ElementTemplate template = ReflectionUtil.getRequiredAnnotation(connectorDefinition, ElementTemplate.class);
        Class<?> connectorInput = template.inputDataClass();
        List<PropertyBuilder> properties = TemplatePropertiesUtil.extractTemplatePropertiesFromType(connectorInput);
        ArrayList<PropertyGroup.PropertyGroupBuilder> groupsDefinedInProperties = new ArrayList<PropertyGroup.PropertyGroupBuilder>(TemplatePropertiesUtil.groupProperties(properties));
        List<ElementTemplate.PropertyGroup> manuallyDefinedGroups = Arrays.asList(template.propertyGroups());
        ArrayList<Object> mergedGroups = new ArrayList();
        if (!manuallyDefinedGroups.isEmpty()) {
            for (ElementTemplate.PropertyGroup group : manuallyDefinedGroups) {
                Optional<PropertyGroup.PropertyGroupBuilder> groupDefinedInProperties = groupsDefinedInProperties.stream().filter(g -> g.build().id().equals(group.id())).findFirst();
                if (groupDefinedInProperties.isEmpty()) {
                    throw new IllegalStateException(String.format("Property group '%s' defined in @ElementTemplate but no properties with this group id found", group.id()));
                }
                mergedGroups.add(PropertyGroup.builder().id(group.id()).label(group.label()).properties(groupDefinedInProperties.get().build().properties()).build());
            }
        } else {
            mergedGroups = new ArrayList<PropertyGroup>(groupsDefinedInProperties.stream().map(PropertyGroup.PropertyGroupBuilder::build).toList());
        }
        if (groupsDefinedInProperties.isEmpty()) {
            mergedGroups.add(PropertyGroup.builder().id("default").label("Properties").properties((PropertyBuilder[])properties.toArray(PropertyBuilder[]::new)).build());
        }
        PropertyGroup outputGroup = PropertyGroup.builder().id("output").label("Output mapping").properties(CommonProperties.RESULT_VARIABLE.binding(new PropertyBinding.ZeebeTaskHeader("resultVariable")).build(), CommonProperties.RESULT_EXPRESSION.binding(new PropertyBinding.ZeebeTaskHeader("resultExpression")).build()).build();
        PropertyGroup errorGroup = PropertyGroup.builder().id("error").label("Error handling").properties(CommonProperties.ERROR_EXPRESSION.binding(new PropertyBinding.ZeebeTaskHeader("errorExpression")).build()).build();
        PropertyGroup retriesGroup = PropertyGroup.builder().id("retries").label("Retries").properties(CommonProperties.RETRY_BACKOFF.binding(new PropertyBinding.ZeebeTaskHeader("retryBackoff")).build()).build();
        mergedGroups.add(outputGroup);
        mergedGroups.add(errorGroup);
        mergedGroups.add(retriesGroup);
        List<PropertyBuilder> nonGroupedProperties = properties.stream().filter(property -> property.build().getGroup() == null).toList();
        ElementTemplateIcon icon = template.icon().isBlank() ? null : this.resolveIcon(template.icon());
        String[] appliesTo = template.appliesTo();
        if (appliesTo == null || appliesTo.length == 0) {
            appliesTo = new String[]{BpmnType.TASK.getName()};
        }
        if ((elementType = template.elementType()).isBlank()) {
            elementType = BpmnType.SERVICE_TASK.getName();
        }
        return OutboundElementTemplate.builder().id(template.id()).type(connector.type(), GeneratorConfiguration.ConnectorMode.HYBRID.equals((Object)configuration.connectorMode())).name(template.name()).version(template.version()).appliesTo(new HashSet<String>(Arrays.asList(appliesTo))).elementType(elementType).icon(icon).documentationRef(template.documentationRef().isEmpty() ? null : template.documentationRef()).description(template.description().isEmpty() ? null : template.description()).properties(nonGroupedProperties.stream().map(PropertyBuilder::build).toList()).propertyGroups(mergedGroups).build();
    }

    public ElementTemplateIcon resolveIcon(String iconDefinition) {
        if (iconDefinition.startsWith("https://")) {
            return new ElementTemplateIcon(iconDefinition);
        }
        try {
            return new ElementTemplateIcon(this.resolveIconFile(iconDefinition));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid icon definition: " + iconDefinition + ", " + e.getMessage(), e);
        }
    }

    private String resolveIconFile(String path) throws IOException {
        String base64Data;
        URL resource = this.classLoader.getResource(path);
        if (resource == null) {
            throw new IllegalArgumentException("Icon file not found: " + path);
        }
        try (InputStream stream = resource.openStream();){
            byte[] bytes = stream.readAllBytes();
            base64Data = Base64.getEncoder().encodeToString(bytes);
        }
        if (path.endsWith(".svg")) {
            return "data:image/svg+xml;base64," + base64Data;
        }
        if (path.endsWith(".png")) {
            return "data:image/png;base64," + base64Data;
        }
        throw new IllegalArgumentException("Unsupported icon file: " + path);
    }
}

