/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb.operation.table;

import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import io.camunda.connector.aws.dynamodb.model.CreateTable;
import io.camunda.connector.aws.dynamodb.operation.AwsDynamoDbOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateTableOperation
implements AwsDynamoDbOperation {
    private final CreateTable createTableModel;

    public CreateTableOperation(CreateTable createTableModel) {
        this.createTableModel = createTableModel;
    }

    @Override
    public TableDescription invoke(DynamoDB dynamoDB) {
        try {
            return dynamoDB.createTable(this.buildCreateTableRequest()).waitForActive();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private CreateTableRequest buildCreateTableRequest() {
        List<KeySchemaElement> keySchemaElements = this.buildKeySchemaElements();
        List<AttributeDefinition> attributeDefinitions = this.buildAttributeDefinitions();
        CreateTableRequest request = new CreateTableRequest().withTableName(this.createTableModel.getTableName()).withKeySchema(keySchemaElements).withAttributeDefinitions(attributeDefinitions).withDeletionProtectionEnabled(this.createTableModel.isDeletionProtection());
        BillingMode billingMode = Optional.ofNullable(this.createTableModel.getBillingModeStr()).map(BillingMode::valueOf).orElse(BillingMode.PROVISIONED);
        request.withBillingMode(billingMode);
        if (BillingMode.PROVISIONED == billingMode) {
            request.withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(this.createTableModel.getReadCapacityUnits()).withWriteCapacityUnits(this.createTableModel.getWriteCapacityUnits()));
        }
        return request;
    }

    private List<KeySchemaElement> buildKeySchemaElements() {
        ArrayList<KeySchemaElement> keySchemaElements = new ArrayList<KeySchemaElement>();
        keySchemaElements.add(new KeySchemaElement(this.createTableModel.getPartitionKey(), this.createTableModel.getPartitionKeyRole()));
        if (Objects.nonNull(this.createTableModel.getSortKey()) && !this.createTableModel.getSortKey().isBlank()) {
            keySchemaElements.add(new KeySchemaElement(this.createTableModel.getSortKey(), this.createTableModel.getSortKeyRole()));
        }
        return keySchemaElements;
    }

    private List<AttributeDefinition> buildAttributeDefinitions() {
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition(this.createTableModel.getPartitionKey(), this.createTableModel.getPartitionKeyType()));
        if (Objects.nonNull(this.createTableModel.getSortKey()) && !this.createTableModel.getSortKey().isBlank()) {
            attributeDefinitions.add(new AttributeDefinition(this.createTableModel.getSortKey(), this.createTableModel.getSortKeyType()));
        }
        return attributeDefinitions;
    }
}

