/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.utils;

import io.camunda.spring.utils.DatabaseTypeUtils;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
@Documented
@Conditional(value={ConditionalOnRdbmsDisabledCondition.class})
public @interface ConditionalOnRdbmsDisabled {

    public static class ConditionalOnRdbmsDisabledCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment env = context.getEnvironment();
            return DatabaseTypeUtils.isRdbmsDisabled(env);
        }
    }
}

