/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.spring.utils;

import java.util.Optional;
import org.springframework.core.env.Environment;

public final class DatabaseTypeUtils {
    public static final String CAMUNDA_DATABASE_TYPE_NONE = "none";
    public static final String PROPERTY_CAMUNDA_DATABASE_TYPE = "camunda.database.type";
    public static final String UNIFIED_CONFIG_PROPERTY_CAMUNDA_DATABASE_TYPE = "camunda.data.secondary-storage.type";

    private DatabaseTypeUtils() {
    }

    public static boolean isSecondaryStorageEnabled(Environment env) {
        String dbType = DatabaseTypeUtils.getDatabaseTypeOrDefault(env);
        return !CAMUNDA_DATABASE_TYPE_NONE.equalsIgnoreCase(dbType);
    }

    public static boolean isRdbmsDisabled(Environment env) {
        String dbType = DatabaseTypeUtils.getDatabaseTypeOrDefault(env);
        return !"rdbms".equalsIgnoreCase(dbType);
    }

    private static String getDatabaseTypeOrDefault(Environment env) {
        return Optional.ofNullable(env.getProperty(UNIFIED_CONFIG_PROPERTY_CAMUNDA_DATABASE_TYPE)).orElse("elasticsearch");
    }
}

