/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.test.utils;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.search.connect.configuration.ConnectConfiguration;
import io.camunda.search.connect.es.ElasticsearchConnector;
import io.camunda.search.connect.os.OpensearchConnector;
import io.camunda.search.test.utils.SearchDBExtension;
import io.camunda.zeebe.test.util.testcontainers.TestSearchContainers;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.testcontainers.OpensearchContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

public class ContainerizedSearchDBExtension
extends SearchDBExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerizedSearchDBExtension.class);
    private static ElasticsearchContainer elasticsearchContainer;
    private static OpensearchContainer opensearchContainer;
    private static ElasticsearchClient elsClient;
    private static OpenSearchClient osClient;
    private ObjectMapper osObjectMapper;
    private ObjectMapper esObjectMapper;

    public void beforeAll(ExtensionContext context) throws Exception {
        elasticsearchContainer = TestSearchContainers.createDefeaultElasticsearchContainer();
        opensearchContainer = TestSearchContainers.createDefaultOpensearchContainer();
        elasticsearchContainer.start();
        opensearchContainer.start();
        ConnectConfiguration config = new ConnectConfiguration();
        config.setUrl(elasticsearchContainer.getHttpHostAddress());
        ElasticsearchConnector esConnector = new ElasticsearchConnector(config);
        this.esObjectMapper = esConnector.objectMapper();
        elsClient = esConnector.createClient();
        ConnectConfiguration osConfig = new ConnectConfiguration();
        osConfig.setType("opensearch");
        osConfig.setUrl(opensearchContainer.getHttpHostAddress());
        OpensearchConnector osConnector = new OpensearchConnector(osConfig);
        this.osObjectMapper = osConnector.objectMapper();
        osClient = osConnector.createClient();
    }

    @Override
    public ObjectMapper objectMapper() {
        return this.osObjectMapper;
    }

    @Override
    public ElasticsearchClient esClient() {
        return elsClient;
    }

    @Override
    public OpenSearchClient osClient() {
        return osClient;
    }

    @Override
    public String esUrl() {
        return elasticsearchContainer.getHttpHostAddress();
    }

    @Override
    public String osUrl() {
        return opensearchContainer.getHttpHostAddress();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        elsClient.close();
        ((OpenSearchTransport)osClient._transport()).close();
    }
}

