/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.test.utils;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.search.connect.configuration.ConnectConfiguration;
import io.camunda.search.connect.os.OpensearchConnector;
import io.camunda.search.test.utils.SearchDBExtension;
import java.util.UUID;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;

public class AWSSearchDBExtension
extends SearchDBExtension {
    private static OpenSearchClient osClient;
    private final String osUrl;
    private ObjectMapper objectMapper;

    public AWSSearchDBExtension(String openSearchAwsInstanceUrl) {
        this.osUrl = openSearchAwsInstanceUrl;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        ConnectConfiguration osConfig = new ConnectConfiguration();
        osConfig.setType("opensearch");
        osConfig.setUrl(this.osUrl);
        osConfig.setIndexPrefix("test-" + String.valueOf(UUID.randomUUID()));
        OpensearchConnector connector = new OpensearchConnector(osConfig);
        this.objectMapper = connector.objectMapper();
        osClient = connector.createClient();
    }

    @Override
    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    @Override
    public ElasticsearchClient esClient() {
        return null;
    }

    @Override
    public OpenSearchClient osClient() {
        return osClient;
    }

    @Override
    public String esUrl() {
        return null;
    }

    @Override
    public String osUrl() {
        return this.osUrl;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        osClient.indices().delete(req -> req.index(IDX_FORM_PREFIX + "*", new String[0]));
        osClient.indices().delete(req -> req.index(CUSTOM_PREFIX + "*", new String[0]));
        osClient.indices().delete(req -> req.index(IDX_PROCESS_PREFIX + "*", new String[0]));
        osClient.indices().delete(req -> req.index(ZEEBE_IDX_PREFIX + "*", new String[0]));
        osClient.indices().delete(req -> req.index(ARCHIVER_IDX_PREFIX + "*", new String[0]));
        osClient.indices().delete(req -> req.index(BATCH_IDX_PREFIX + "*", new String[0]));
        osClient.indices().delete(req -> req.index(INCIDENT_IDX_PREFIX + "*", new String[0]));
        osClient.indices().delete(req -> req.index("*" + ENGINE_CLIENT_TEST_MARKERS + "*", new String[0]));
        ((OpenSearchTransport)osClient._transport()).close();
    }
}

