/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.test.utils;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.ilm.get_lifecycle.Lifecycle;
import co.elastic.clients.elasticsearch.indices.GetIndexResponse;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.json.jackson.JacksonJsonpGenerator;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.generic.Body;
import org.opensearch.client.opensearch.generic.Request;
import org.opensearch.client.opensearch.generic.Requests;
import org.opensearch.client.opensearch.indices.IndexState;
import org.opensearch.client.opensearch.indices.get_index_template.IndexTemplateItem;
import org.opensearch.client.transport.OpenSearchTransport;

public class SearchClientAdapter {
    private final ElasticsearchClient elsClient;
    private final OpenSearchClient osClient;
    private final SchemaResourceSerializer schemaResourceSerializer;
    private final ObjectMapper objectMapper;

    public SearchClientAdapter(ElasticsearchClient elsClient, ObjectMapper objectMapper) {
        Objects.requireNonNull(elsClient, "elsClient cannot be null");
        this.elsClient = elsClient;
        this.osClient = null;
        this.objectMapper = objectMapper;
        this.schemaResourceSerializer = new SchemaResourceSerializer(objectMapper);
    }

    public SearchClientAdapter(OpenSearchClient osClient, ObjectMapper objectMapper) {
        Objects.requireNonNull(osClient, "osClient cannot be null");
        this.elsClient = null;
        this.objectMapper = objectMapper;
        this.osClient = osClient;
        this.schemaResourceSerializer = new SchemaResourceSerializer(objectMapper);
    }

    public ElasticsearchClient getElsClient() {
        return this.elsClient;
    }

    private JsonNode opensearchIndexToNode(IndexState index) {
        Map<String, Object> indexAsMap;
        try {
            indexAsMap = this.schemaResourceSerializer.serialize(JacksonJsonpGenerator::new, gen -> index.serialize(gen, ((OpenSearchTransport)this.osClient._transport()).jsonpMapper()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.objectMapper.valueToTree(indexAsMap);
    }

    private JsonNode elsIndexToNode(co.elastic.clients.elasticsearch.indices.IndexState index) {
        Map<String, Object> indexAsMap;
        try {
            indexAsMap = this.schemaResourceSerializer.serialize(co.elastic.clients.json.jackson.JacksonJsonpGenerator::new, gen -> index.serialize(gen, this.elsClient._jsonpMapper()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.objectMapper.valueToTree(indexAsMap);
    }

    private JsonNode elsIndexTemplateToNode(co.elastic.clients.elasticsearch.indices.get_index_template.IndexTemplateItem indexTemplate) throws IOException {
        Map<String, Object> templateAsMap = this.schemaResourceSerializer.serialize(co.elastic.clients.json.jackson.JacksonJsonpGenerator::new, gen -> indexTemplate.serialize(gen, this.elsClient._jsonpMapper()));
        return this.objectMapper.valueToTree(templateAsMap);
    }

    private JsonNode opensearchIndexTemplateToNode(IndexTemplateItem indexTemplate) throws IOException {
        Map<String, Object> templateAsMap = this.schemaResourceSerializer.serialize(JacksonJsonpGenerator::new, gen -> indexTemplate.serialize(gen, ((OpenSearchTransport)this.osClient._transport()).jsonpMapper()));
        return this.objectMapper.valueToTree(templateAsMap);
    }

    private JsonNode elsPolicyToNode(Lifecycle lifecyclePolicy) throws IOException {
        Map<String, Object> policyAsMap = this.schemaResourceSerializer.serialize(co.elastic.clients.json.jackson.JacksonJsonpGenerator::new, gen -> lifecyclePolicy.serialize(gen, this.elsClient._jsonpMapper()));
        return this.objectMapper.valueToTree(policyAsMap);
    }

    public JsonNode getIndexAsNode(String indexName) throws IOException {
        if (this.elsClient != null) {
            co.elastic.clients.elasticsearch.indices.IndexState index = this.elsClient.indices().get(req -> req.index(indexName, new String[0])).get(indexName);
            return this.elsIndexToNode(index);
        }
        if (this.osClient != null) {
            IndexState index = (IndexState)this.osClient.indices().get(req -> req.index(indexName, new String[0])).get(indexName);
            return this.opensearchIndexToNode(index);
        }
        return null;
    }

    public Map<String, JsonNode> getAllIndicesAsNode(String indexPrefix) throws IOException {
        if (this.elsClient != null) {
            GetIndexResponse indices = this.elsClient.indices().get(req -> req.index(indexPrefix + "*", new String[0]));
            return indices.result().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.elsIndexToNode((co.elastic.clients.elasticsearch.indices.IndexState)e.getValue())));
        }
        if (this.osClient != null) {
            org.opensearch.client.opensearch.indices.GetIndexResponse indices = this.osClient.indices().get(req -> req.index(indexPrefix + "*", new String[0]));
            return indices.result().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.opensearchIndexToNode((IndexState)e.getValue())));
        }
        return null;
    }

    public JsonNode getPolicyAsNode(String policyName) throws IOException {
        if (this.elsClient != null) {
            Lifecycle policy = (Lifecycle)this.elsClient.ilm().getLifecycle(req -> req.name(policyName)).result().get(policyName);
            return this.elsPolicyToNode(policy);
        }
        if (this.osClient != null) {
            Request request = Requests.builder().method("GET").endpoint("_plugins/_ism/policies/" + policyName).build();
            return this.objectMapper.readTree(((Body)this.osClient.generic().execute(request).getBody().get()).body());
        }
        return null;
    }

    public JsonNode getIndexTemplateAsNode(String templateName) throws IOException {
        if (this.elsClient != null) {
            co.elastic.clients.elasticsearch.indices.get_index_template.IndexTemplateItem template = (co.elastic.clients.elasticsearch.indices.get_index_template.IndexTemplateItem)this.elsClient.indices().getIndexTemplate(req -> req.name(templateName)).indexTemplates().getFirst();
            return this.elsIndexTemplateToNode(template);
        }
        if (this.osClient != null) {
            IndexTemplateItem template = (IndexTemplateItem)this.osClient.indices().getIndexTemplate(req -> req.name(templateName)).indexTemplates().getFirst();
            return this.opensearchIndexTemplateToNode(template);
        }
        return null;
    }

    public <T> T get(String id, String index, Class<T> classType) throws IOException {
        if (this.elsClient != null) {
            return (T)this.elsClient.get(r -> r.id(id).index(index), classType).source();
        }
        if (this.osClient != null) {
            return (T)this.osClient.get(r -> r.id(id).index(index), classType).source();
        }
        return null;
    }

    public String index(String id, String index, Object document) throws IOException {
        if (this.elsClient != null) {
            return this.elsClient.index(i -> i.index(index).id(id).document(document)).result().jsonValue();
        }
        if (this.osClient != null) {
            return this.osClient.index(i -> i.index(index).id(id).document(document)).result().jsonValue();
        }
        return "";
    }

    public void createIndex(String indexName, int numberOfReplicas) throws IOException {
        if (this.elsClient != null) {
            this.elsClient.indices().create(c -> c.index(indexName).settings(settings -> settings.numberOfShards("1").numberOfReplicas(String.valueOf(numberOfReplicas))));
        } else if (this.osClient != null) {
            this.osClient.indices().create(c -> c.index(indexName).settings(settings -> settings.numberOfShards("1").numberOfReplicas(String.valueOf(numberOfReplicas))));
        }
    }

    public void refresh() throws IOException {
        if (this.elsClient != null) {
            this.elsClient.indices().refresh();
        } else if (this.osClient != null) {
            this.osClient.indices().refresh();
        }
    }

    private static final class SchemaResourceSerializer {
        private final ObjectMapper objectMapper;

        public SchemaResourceSerializer(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        /*
         * Exception decompiling
         */
        public Map<String, Object> serialize(Function<com.fasterxml.jackson.core.JsonGenerator, JsonGenerator> jacksonGenerator, Consumer<JsonGenerator> serialize) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

