/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.query;

import io.camunda.search.aggregation.AggregationBase;
import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.clients.core.RequestBuilders;
import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.source.SearchSourceConfig;
import io.camunda.search.clients.transformers.ServiceTransformer;
import io.camunda.search.clients.transformers.ServiceTransformers;
import io.camunda.search.clients.transformers.filter.FilterTransformer;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.clients.transformers.query.Cursor;
import io.camunda.search.clients.transformers.result.ResultConfigTransformer;
import io.camunda.search.clients.transformers.sort.SortingTransformer;
import io.camunda.search.filter.FilterBase;
import io.camunda.search.page.SearchQueryPage;
import io.camunda.search.query.AggregationPaginated;
import io.camunda.search.query.TypedSearchQuery;
import io.camunda.search.result.QueryResultConfig;
import io.camunda.search.sort.NoSort;
import io.camunda.search.sort.SearchSortOptions;
import io.camunda.search.sort.SortOption;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.List;
import java.util.Optional;

public class TypedSearchQueryTransformer<F extends FilterBase, S extends SortOption>
implements ServiceTransformer<TypedSearchQuery<F, S>, SearchQueryRequest> {
    private final ServiceTransformers transformers;

    public TypedSearchQueryTransformer(ServiceTransformers transformers) {
        this.transformers = transformers;
    }

    @Override
    public SearchQueryRequest apply(TypedSearchQuery<F, S> query) {
        return this.apply(query, null);
    }

    public SearchQueryRequest apply(TypedSearchQuery<F, S> query, ResourceAccessChecks resourceAccessChecks) {
        FilterBase filter = query.filter();
        SearchQuery searchQueryFilter = this.toSearchQuery(filter, resourceAccessChecks);
        List<String> indices = this.toIndices(filter);
        SearchQueryRequest.Builder builder = RequestBuilders.searchRequest().index(indices).query(searchQueryFilter);
        this.buildPagination(query, builder);
        QueryResultConfig resultConfig = query.resultConfig();
        SearchSourceConfig searchQuerySourceConfig = this.toSearchSourceConfig(resultConfig);
        if (searchQuerySourceConfig != null) {
            builder.source(searchQuerySourceConfig);
        }
        Optional.ofNullable(query.aggregation()).ifPresent(aggregation -> builder.aggregations(this.toAggregations((AggregationBase)aggregation)));
        return builder.build();
    }

    private SearchSourceConfig toSearchSourceConfig(QueryResultConfig resultConfig) {
        if (resultConfig == null) {
            return null;
        }
        ResultConfigTransformer<QueryResultConfig> resultConfigTransformer = this.getResultConfigTransformer(resultConfig.getClass());
        return (SearchSourceConfig)resultConfigTransformer.apply(resultConfig);
    }

    private SearchQuery toSearchQuery(F filter, ResourceAccessChecks resourceAccessChecks) {
        return ((IndexFilterTransformer)this.getFilterTransformer(filter)).toSearchQuery(filter, resourceAccessChecks);
    }

    private List<String> toIndices(F filter) {
        return List.of(this.getFilterTransformer(filter).getIndex().getAlias());
    }

    protected List<SearchAggregator> toAggregations(AggregationBase aggregation) {
        return (List)this.transformers.getAggregationTransformer(aggregation.getClass()).apply(Tuple.of((Object)aggregation, (Object)this.transformers));
    }

    private List<SearchSortOptions> toSearchSortOptions(S sort, boolean reverse) {
        List orderings = sort.getFieldSortings();
        SortingTransformer sortingTransformer = this.getSortingTransformer(sort.getClass());
        return sortingTransformer.apply((Tuple<List<SortOption.FieldSorting>, Boolean>)Tuple.of((Object)orderings, (Object)reverse));
    }

    private FilterTransformer<F> getFilterTransformer(F filter) {
        return this.transformers.getFilterTransformer(filter.getClass());
    }

    private SortingTransformer getSortingTransformer(Class<? extends SortOption> cls) {
        return new SortingTransformer(this.transformers.getFieldSortingTransformer(cls));
    }

    private <T extends QueryResultConfig> ResultConfigTransformer<QueryResultConfig> getResultConfigTransformer(Class<T> clazz) {
        ServiceTransformer transformer = this.transformers.getTransformer(clazz);
        return (ResultConfigTransformer)transformer;
    }

    private void buildPagination(TypedSearchQuery<F, S> query, SearchQueryRequest.Builder builder) {
        String searchAfter;
        List<SearchSortOptions> sorting;
        if (query.aggregation() instanceof AggregationPaginated) {
            builder.size(0);
            return;
        }
        SearchQueryPage page = query.page();
        boolean reverse = !page.isNextPage();
        builder.from(page.from()).size(page.size());
        SortOption sort = query.sort();
        if (!(sort instanceof NoSort) && !(sorting = this.toSearchSortOptions(sort, reverse)).isEmpty()) {
            builder.sort(query.retainValidSortings(sorting));
        }
        if ((searchAfter = page.startNextPageAfter()) != null) {
            builder.searchAfter(Cursor.decode(searchAfter));
        }
    }
}

