/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.Base64;

public class Cursor {
    static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().enable(new DeserializationFeature[]{DeserializationFeature.USE_LONG_FOR_INTS})).build();

    public static String encode(Object[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        try {
            String value = MAPPER.writeValueAsString((Object)values);
            return Base64.getEncoder().encodeToString(value.getBytes());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object[] decode(String cursor) {
        if (cursor == null || cursor.isEmpty()) {
            return null;
        }
        try {
            byte[] decodedCursor = Base64.getDecoder().decode(cursor);
            return (Object[])MAPPER.readValue(decodedCursor, Object[].class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

