/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.Operation;
import io.camunda.search.filter.UntypedOperation;
import io.camunda.search.filter.VariableFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class VariableFilterTransformer
extends IndexFilterTransformer<VariableFilter> {
    public VariableFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(VariableFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        queries.addAll(SearchQueryBuilders.stringOperations("name", filter.nameOperations()));
        queries.addAll(this.getVariablesQuery(filter.valueOperations()));
        queries.addAll(this.getScopeKeyQuery(filter.scopeKeyOperations()));
        queries.addAll(this.getProcessInstanceKeyQuery(filter.processInstanceKeyOperations()));
        queries.addAll(this.getVariableKeyQuery(filter.variableKeyOperations()));
        Optional.ofNullable(this.getTenantIdQuery(filter.tenantIds())).ifPresent(queries::add);
        Optional.ofNullable(this.getIsTruncatedQuery(filter.isTruncated())).ifPresent(queries::add);
        return SearchQueryBuilders.and(queries);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("bpmnProcessId", authorization.resourceIds());
    }

    private List<SearchQuery> getVariablesQuery(List<UntypedOperation> variableFilters) {
        return SearchQueryBuilders.variableOperations("value", variableFilters);
    }

    private List<SearchQuery> getScopeKeyQuery(List<Operation<Long>> scopeKey) {
        return SearchQueryBuilders.longOperations("scopeKey", scopeKey);
    }

    private List<SearchQuery> getProcessInstanceKeyQuery(List<Operation<Long>> processInstanceKey) {
        return SearchQueryBuilders.longOperations("processInstanceKey", processInstanceKey);
    }

    private List<SearchQuery> getVariableKeyQuery(List<Operation<Long>> variableKeys) {
        return SearchQueryBuilders.longOperations("key", variableKeys);
    }

    private SearchQuery getTenantIdQuery(List<String> tenant) {
        return SearchQueryBuilders.stringTerms("tenantId", tenant);
    }

    private SearchQuery getIsTruncatedQuery(Boolean isTruncated) {
        if (isTruncated == null) {
            return null;
        }
        return SearchQueryBuilders.term("isPreview", isTruncated);
    }
}

