/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.UserFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.ArrayList;

public class UserFilterTransformer
extends IndexFilterTransformer<UserFilter> {
    public UserFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(UserFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        if (filter.key() != null) {
            queries.add(SearchQueryBuilders.term("key", filter.key()));
        }
        queries.addAll(SearchQueryBuilders.stringOperations("username", filter.usernameOperations()));
        queries.addAll(SearchQueryBuilders.stringOperations("name", filter.nameOperations()));
        queries.addAll(SearchQueryBuilders.stringOperations("email", filter.emailOperations()));
        return SearchQueryBuilders.and(queries);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("username", authorization.resourceIds());
    }
}

