/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.TenantFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.webapps.schema.entities.usermanagement.EntityJoinRelation;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.Collection;

public class TenantFilterTransformer
extends IndexFilterTransformer<TenantFilter> {
    public TenantFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(TenantFilter filter) {
        if (filter.memberIdsByType() != null && !filter.memberIdsByType().isEmpty()) {
            return this.createMultipleMemberTypeQueries(filter);
        }
        return SearchQueryBuilders.and(this.buildCoreFilters(filter), filter.memberIds() == null ? null : (filter.memberIds().isEmpty() ? SearchQueryBuilders.matchNone() : SearchQueryBuilders.hasChildQuery(EntityJoinRelation.IdentityJoinRelationshipType.MEMBER.getType(), SearchQueryBuilders.stringTerms("memberId", filter.memberIds()))), filter.entityType() == null ? null : SearchQueryBuilders.term("memberType", filter.entityType().name()), filter.childMemberType() == null ? null : SearchQueryBuilders.hasChildQuery(EntityJoinRelation.IdentityJoinRelationshipType.MEMBER.getType(), SearchQueryBuilders.term("memberType", filter.childMemberType().name())));
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("tenantId", authorization.resourceIds());
    }

    private SearchQuery createMultipleMemberTypeQueries(TenantFilter filter) {
        return SearchQueryBuilders.or(filter.memberIdsByType().entrySet().stream().map(entry -> SearchQueryBuilders.and(this.buildCoreFilters(filter), SearchQueryBuilders.hasChildQuery(EntityJoinRelation.IdentityJoinRelationshipType.MEMBER.getType(), SearchQueryBuilders.and(SearchQueryBuilders.term("memberType", ((EntityType)entry.getKey()).name()), SearchQueryBuilders.stringTerms("memberId", (Collection)entry.getValue()))))).toList());
    }

    private SearchQuery buildCoreFilters(TenantFilter filter) {
        return SearchQueryBuilders.and(filter.key() == null ? null : SearchQueryBuilders.term("key", filter.key()), filter.tenantIds() == null ? null : SearchQueryBuilders.stringTerms("tenantId", filter.tenantIds()), filter.name() == null ? null : SearchQueryBuilders.term("name", filter.name()), filter.joinParentId() == null ? SearchQueryBuilders.term("join", EntityJoinRelation.IdentityJoinRelationshipType.TENANT.getType()) : SearchQueryBuilders.hasParentQuery(EntityJoinRelation.IdentityJoinRelationshipType.TENANT.getType(), SearchQueryBuilders.term("tenantId", filter.joinParentId())));
    }
}

