/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.Operation;
import io.camunda.search.filter.ProcessDefinitionFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ProcessDefinitionFilterTransformer
extends IndexFilterTransformer<ProcessDefinitionFilter> {
    public ProcessDefinitionFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(ProcessDefinitionFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        Optional.ofNullable(SearchQueryBuilders.longTerms("key", filter.processDefinitionKeys())).ifPresent(queries::add);
        Optional.ofNullable(this.getNamesQuery(filter.nameOperations())).ifPresent(queries::addAll);
        Optional.ofNullable(this.getProcessDefinitionIdsQuery(filter.processDefinitionIdOperations())).ifPresent(queries::addAll);
        Optional.ofNullable(SearchQueryBuilders.stringTerms("resourceName", filter.resourceNames())).ifPresent(queries::add);
        Optional.ofNullable(SearchQueryBuilders.intTerms("version", filter.versions())).ifPresent(queries::add);
        Optional.ofNullable(SearchQueryBuilders.stringTerms("versionTag", filter.versionTags())).ifPresent(queries::add);
        Optional.ofNullable(SearchQueryBuilders.stringTerms("tenantId", filter.tenantIds())).ifPresent(queries::add);
        Optional.ofNullable(this.getHasStartFormQuery(filter.hasStartForm())).ifPresent(queries::add);
        return SearchQueryBuilders.and(queries);
    }

    private List<SearchQuery> getNamesQuery(List<Operation<String>> names) {
        return SearchQueryBuilders.stringOperations("name", names);
    }

    private List<SearchQuery> getProcessDefinitionIdsQuery(List<Operation<String>> processDefinitionIds) {
        return SearchQueryBuilders.stringOperations("bpmnProcessId", processDefinitionIds);
    }

    private SearchQuery getHasStartFormQuery(Boolean hasStartForm) {
        if (hasStartForm != null) {
            return SearchQueryBuilders.bool(b -> {
                if (hasStartForm.booleanValue()) {
                    b.must(List.of(SearchQueryBuilders.exists("formId")));
                } else {
                    b.mustNot(List.of(SearchQueryBuilders.exists("formId")));
                }
                return b;
            }).toSearchQuery();
        }
        return null;
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("bpmnProcessId", authorization.resourceIds());
    }
}

