/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchMatchAllQuery;
import io.camunda.search.clients.query.SearchMatchNoneQuery;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.FilterTransformer;
import io.camunda.search.exception.CamundaSearchException;
import io.camunda.search.filter.FilterBase;
import io.camunda.security.auth.Authorization;
import io.camunda.security.reader.AuthorizationCheck;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.security.reader.TenantCheck;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexFilterTransformer<T extends FilterBase>
implements FilterTransformer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(IndexFilterTransformer.class);
    private final IndexDescriptor indexDescriptor;

    public IndexFilterTransformer(IndexDescriptor indexDescriptor) {
        this.indexDescriptor = indexDescriptor;
    }

    public SearchQuery toSearchQuery(T filter, ResourceAccessChecks resourceAccessChecks) {
        SearchQuery filterSearchQuery = Optional.ofNullable(this.toSearchQuery(filter)).orElseGet(SearchQueryBuilders::matchAll);
        if (resourceAccessChecks == null) {
            return this.rewriteSearchQueries(List.of(filterSearchQuery));
        }
        SearchQuery authorizationSearchQuery = Optional.of(resourceAccessChecks.authorizationCheck()).map(this::applyAuthorizationChecks).orElseThrow(() -> {
            String message = "Transformer '%s' requires an authorization check to be applied to the search query.".formatted(this.getClass().getSimpleName());
            LOG.error(message);
            return new CamundaSearchException(message);
        });
        SearchQuery tenantSearchQuery = Optional.of(resourceAccessChecks.tenantCheck()).map(this::applyTenantChecks).orElseThrow(() -> {
            String message = "Transformer '%s' requires a tenant check to be applied to the search query.".formatted(this.getClass().getSimpleName());
            LOG.error(message);
            return new CamundaSearchException(message);
        });
        return this.rewriteSearchQueries(List.of(filterSearchQuery, authorizationSearchQuery, tenantSearchQuery));
    }

    private SearchQuery applyAuthorizationChecks(AuthorizationCheck authorizationCheck) {
        if (!authorizationCheck.enabled()) {
            return SearchQueryBuilders.matchAll();
        }
        Authorization authorization = authorizationCheck.authorization();
        List resourceIds = authorization.resourceIds();
        if (resourceIds == null || resourceIds.isEmpty()) {
            return SearchQueryBuilders.matchNone();
        }
        return this.toAuthorizationCheckSearchQuery(authorization);
    }

    private SearchQuery applyTenantChecks(TenantCheck tenantCheck) {
        Optional field = Optional.of(this.indexDescriptor).flatMap(IndexDescriptor::getTenantIdField);
        if (field.isEmpty() || !tenantCheck.enabled()) {
            return SearchQueryBuilders.matchAll();
        }
        return Optional.of(tenantCheck).map(TenantCheck::tenantIds).filter(t -> !t.isEmpty()).map(t -> SearchQueryBuilders.stringTerms((String)field.get(), t)).orElse(SearchQueryBuilders.matchNone());
    }

    private SearchQuery rewriteSearchQueries(List<SearchQuery> queries) {
        boolean anyNonMatchQuery = queries.stream().filter(Objects::nonNull).map(SearchQuery::queryOption).anyMatch(SearchMatchNoneQuery.class::isInstance);
        if (anyNonMatchQuery) {
            return SearchQueryBuilders.matchNone();
        }
        List<SearchQuery> filteredQueries = queries.stream().filter(Objects::nonNull).filter(q -> !(q.queryOption() instanceof SearchMatchAllQuery)).toList();
        return SearchQueryBuilders.and(filteredQueries);
    }

    protected abstract SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> var1);

    @Override
    public IndexDescriptor getIndex() {
        return this.indexDescriptor;
    }
}

