/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.FormFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.Optional;

public class FormFilterTransformer
extends IndexFilterTransformer<FormFilter> {
    public FormFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(FormFilter filter) {
        SearchQuery tenantFilter = Optional.ofNullable(filter.tenantId()).map(t -> SearchQueryBuilders.term("tenantId", t)).orElse(null);
        return SearchQueryBuilders.and(SearchQueryBuilders.longTerms("key", filter.formKeys()), SearchQueryBuilders.stringTerms("bpmnId", filter.formIds()), tenantFilter);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.matchAll();
    }
}

