/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.entities.FlowNodeInstanceEntity;
import io.camunda.search.filter.FlowNodeInstanceFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FlownodeInstanceFilterTransformer
extends IndexFilterTransformer<FlowNodeInstanceFilter> {
    public FlownodeInstanceFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(FlowNodeInstanceFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        Optional.ofNullable(SearchQueryBuilders.longTerms("key", filter.flowNodeInstanceKeys())).ifPresent(queries::add);
        Optional.ofNullable(SearchQueryBuilders.longTerms("processInstanceKey", filter.processInstanceKeys())).ifPresent(queries::add);
        Optional.ofNullable(SearchQueryBuilders.longTerms("processDefinitionKey", filter.processDefinitionKeys())).ifPresent(queries::add);
        Optional.ofNullable(SearchQueryBuilders.stringTerms("bpmnProcessId", filter.processDefinitionIds())).ifPresent(queries::add);
        Optional.ofNullable(this.getTypeQuery(filter.types())).ifPresent(queries::add);
        queries.addAll(SearchQueryBuilders.stringOperations("state", filter.stateOperations()));
        Optional.ofNullable(SearchQueryBuilders.stringTerms("flowNodeId", filter.flowNodeIds())).ifPresent(queries::add);
        Optional.ofNullable(SearchQueryBuilders.stringTerms("flowNodeName", filter.flowNodeNames())).ifPresent(queries::add);
        Optional.ofNullable(SearchQueryBuilders.longTerms("incidentKey", filter.incidentKeys())).ifPresent(queries::add);
        Optional.ofNullable(filter.hasIncident()).ifPresent(f -> queries.add(SearchQueryBuilders.term("incident", f)));
        Optional.ofNullable(SearchQueryBuilders.stringTerms("tenantId", filter.tenantIds())).ifPresent(queries::add);
        queries.addAll(SearchQueryBuilders.dateTimeOperations("startDate", filter.startDateOperations()));
        queries.addAll(SearchQueryBuilders.dateTimeOperations("endDate", filter.endDateOperations()));
        Optional.ofNullable(SearchQueryBuilders.intTerms("level", filter.levels())).ifPresent(queries::add);
        if (filter.useTreePathPrefix() != null && filter.useTreePathPrefix().booleanValue()) {
            Optional.ofNullable(SearchQueryBuilders.prefix("treePath", (String)filter.treePaths().getFirst())).ifPresent(queries::add);
        } else {
            Optional.ofNullable(SearchQueryBuilders.stringTerms("treePath", filter.treePaths())).ifPresent(queries::add);
        }
        return SearchQueryBuilders.and(queries);
    }

    private SearchQuery getTypeQuery(List<FlowNodeInstanceEntity.FlowNodeType> types) {
        return SearchQueryBuilders.stringTerms("type", types != null ? types.stream().map(Enum::name).toList() : null);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("bpmnProcessId", authorization.resourceIds());
    }
}

