/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.entities.DecisionInstanceEntity;
import io.camunda.search.filter.DecisionInstanceFilter;
import io.camunda.search.filter.Operation;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class DecisionInstanceFilterTransformer
extends IndexFilterTransformer<DecisionInstanceFilter> {
    public DecisionInstanceFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(DecisionInstanceFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        Optional.ofNullable(this.getKeysQuery(filter.decisionInstanceKeys())).ifPresent(queries::add);
        Optional.ofNullable(this.getIdsQuery(filter.decisionInstanceIds())).ifPresent(queries::add);
        Optional.ofNullable(this.getStatesQuery(filter.states())).ifPresent(queries::add);
        queries.addAll(this.getEvaluationDateQuery(filter.evaluationDateOperations()));
        Optional.ofNullable(this.getEvaluationFailuresQuery(filter.evaluationFailures())).ifPresent(queries::add);
        Optional.ofNullable(this.getProcessDefinitionKeysQuery(filter.processDefinitionKeys())).ifPresent(queries::add);
        Optional.ofNullable(this.getProcessInstanceKeysQuery(filter.processInstanceKeys())).ifPresent(queries::add);
        queries.addAll(this.getDecisionDefinitionKeysQuery(filter.decisionDefinitionKeyOperations()));
        queries.addAll(this.getFlowNodeInstanceKeysQuery(filter.flowNodeInstanceKeyOperations()));
        Optional.ofNullable(this.getDecisionDefinitionIdsQuery(filter.decisionDefinitionIds())).ifPresent(queries::add);
        Optional.ofNullable(this.getDecisionDefinitionNamesQuery(filter.decisionDefinitionNames())).ifPresent(queries::add);
        Optional.ofNullable(this.getDecisionDefinitionVersionsQuery(filter.decisionDefinitionVersions())).ifPresent(queries::add);
        Optional.ofNullable(this.getDecisionDefinitionTypesQuery(filter.decisionTypes())).ifPresent(queries::add);
        Optional.ofNullable(this.getTenantIdsQuery(filter.tenantIds())).ifPresent(queries::add);
        return SearchQueryBuilders.and(queries);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("decisionId", authorization.resourceIds());
    }

    private SearchQuery getKeysQuery(List<Long> keys) {
        return SearchQueryBuilders.longTerms("key", keys);
    }

    private SearchQuery getIdsQuery(List<String> ids) {
        return SearchQueryBuilders.stringTerms("id", ids);
    }

    private SearchQuery getStatesQuery(List<DecisionInstanceEntity.DecisionInstanceState> states) {
        return SearchQueryBuilders.stringTerms("state", states != null ? states.stream().map(Enum::name).toList() : null);
    }

    private List<SearchQuery> getEvaluationDateQuery(List<Operation<OffsetDateTime>> evaluationDateOperations) {
        return SearchQueryBuilders.dateTimeOperations("evaluationDate", evaluationDateOperations);
    }

    private SearchQuery getEvaluationFailuresQuery(List<String> evaluationFailures) {
        return SearchQueryBuilders.or(SearchQueryBuilders.stringTerms("evaluationFailureMessage", evaluationFailures), SearchQueryBuilders.stringTerms("evaluationFailure", evaluationFailures));
    }

    private SearchQuery getProcessDefinitionKeysQuery(List<Long> processDefinitionKeys) {
        return SearchQueryBuilders.longTerms("processDefinitionKey", processDefinitionKeys);
    }

    private SearchQuery getProcessInstanceKeysQuery(List<Long> processInstanceKeys) {
        return SearchQueryBuilders.longTerms("processInstanceKey", processInstanceKeys);
    }

    private List<SearchQuery> getDecisionDefinitionKeysQuery(List<Operation<Long>> decisionDefinitionKeyOperations) {
        List<Operation> stringOperations = decisionDefinitionKeyOperations.stream().map(op -> {
            List<String> values = op.values().stream().map(String::valueOf).toList();
            return new Operation(op.operator(), values);
        }).toList();
        return SearchQueryBuilders.stringOperations("decisionDefinitionId", stringOperations);
    }

    private List<SearchQuery> getFlowNodeInstanceKeysQuery(List<Operation<Long>> flowNodeInstanceKeyOperations) {
        return SearchQueryBuilders.longOperations("elementInstanceKey", flowNodeInstanceKeyOperations);
    }

    private SearchQuery getDecisionDefinitionIdsQuery(List<String> decisionDefinitionIds) {
        return SearchQueryBuilders.stringTerms("decisionId", decisionDefinitionIds);
    }

    private SearchQuery getDecisionDefinitionNamesQuery(List<String> decisionDefinitionNames) {
        return SearchQueryBuilders.stringTerms("decisionName", decisionDefinitionNames);
    }

    private SearchQuery getDecisionDefinitionVersionsQuery(List<Integer> decisionDefinitionVersions) {
        return SearchQueryBuilders.intTerms("decisionVersion", decisionDefinitionVersions);
    }

    private SearchQuery getDecisionDefinitionTypesQuery(List<DecisionInstanceEntity.DecisionDefinitionType> decisionTypes) {
        return SearchQueryBuilders.stringTerms("decisionType", decisionTypes != null ? decisionTypes.stream().map(Enum::name).toList() : null);
    }

    private SearchQuery getTenantIdsQuery(List<String> tenantIds) {
        return SearchQueryBuilders.stringTerms("tenantId", tenantIds);
    }
}

