/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.BatchOperationItemFilter;
import io.camunda.search.filter.Operation;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.List;

public final class BatchOperationItemFilterTransformer
extends IndexFilterTransformer<BatchOperationItemFilter> {
    public BatchOperationItemFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(BatchOperationItemFilter filter) {
        return SearchQueryBuilders.and(SearchQueryBuilders.stringOperations("batchOperationId", filter.batchOperationKeyOperations()), SearchQueryBuilders.stringOperations("state", this.mapStateOperations(filter.stateOperations())), SearchQueryBuilders.longOperations("itemKey", filter.itemKeyOperations()), SearchQueryBuilders.longOperations("processInstanceKey", filter.processInstanceKeyOperations()));
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.matchAll();
    }

    private List<Operation<String>> mapStateOperations(List<Operation<String>> stateOperations) {
        if (stateOperations == null) {
            return null;
        }
        return stateOperations.stream().map(o -> new Operation(o.operator(), o.values().stream().map(this::mapState).toList())).toList();
    }

    private String mapState(String state) {
        return switch (state) {
            case "ACTIVE" -> "SCHEDULED";
            case "COMPLETED" -> "COMPLETED";
            case "CANCELED" -> "CANCELED";
            case "FAILED" -> "FAILED";
            default -> throw new IllegalArgumentException("Unknown batch operation item state: " + state);
        };
    }
}

