/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.exception.CamundaSearchException;
import io.camunda.search.filter.AuthorizationFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.Set;

public final class AuthorizationFilterTransformer
extends IndexFilterTransformer<AuthorizationFilter> {
    public AuthorizationFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(AuthorizationFilter filter) {
        return SearchQueryBuilders.and(this.buildCoreFilters(filter), filter.ownerTypeToOwnerIds() != null ? this.buildOwnerTypeToOwnerIdsQuery(filter) : null, SearchQueryBuilders.stringTerms("ownerId", filter.ownerIds()), filter.ownerType() == null ? null : SearchQueryBuilders.term("ownerType", filter.ownerType()));
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.longTerms("id", authorization.resourceIds().stream().map(Long::valueOf).toList());
    }

    private SearchQuery buildOwnerTypeToOwnerIdsQuery(AuthorizationFilter filter) {
        return SearchQueryBuilders.or(filter.ownerTypeToOwnerIds().entrySet().stream().map(entry -> {
            EntityType key = (EntityType)entry.getKey();
            Set value = (Set)entry.getValue();
            if (value == null || value.isEmpty()) {
                String message = "Cannot build owner type to owner ids query, because value for owner type '%s' is null or empty.".formatted(key.name());
                throw new CamundaSearchException(message);
            }
            return SearchQueryBuilders.and(SearchQueryBuilders.term("ownerType", key.name()), SearchQueryBuilders.stringTerms("ownerId", value));
        }).toList());
    }

    private SearchQuery buildCoreFilters(AuthorizationFilter filter) {
        return SearchQueryBuilders.and(filter.authorizationKey() == null ? null : SearchQueryBuilders.term("id", filter.authorizationKey()), SearchQueryBuilders.stringTerms("resourceId", filter.resourceIds()), filter.resourceMatcher() == null ? null : SearchQueryBuilders.term("resourceMatcher", filter.resourceMatcher()), filter.resourceType() == null ? null : SearchQueryBuilders.term("resourceType", filter.resourceType()), filter.permissionTypes() == null ? null : SearchQueryBuilders.stringTerms("permissionTypes", filter.permissionTypes().stream().map(Enum::name).toList()));
    }
}

