/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.entity;

import io.camunda.search.clients.transformers.ServiceTransformer;
import io.camunda.search.entities.BatchOperationEntity;
import io.camunda.search.entities.BatchOperationType;
import io.camunda.webapps.schema.entities.operation.BatchOperationEntity;
import io.camunda.webapps.schema.entities.operation.BatchOperationErrorEntity;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class BatchOperationEntityTransformer
implements ServiceTransformer<BatchOperationEntity, io.camunda.search.entities.BatchOperationEntity> {
    @Override
    public io.camunda.search.entities.BatchOperationEntity apply(BatchOperationEntity source) {
        if (source == null) {
            return null;
        }
        return BatchOperationEntityTransformer.isLegacy(source) ? this.mapLegacyBatchOperation(source) : this.mapBatchOperation(source);
    }

    private static boolean isLegacy(BatchOperationEntity source) {
        return !StringUtils.isNumeric((CharSequence)source.getId());
    }

    private io.camunda.search.entities.BatchOperationEntity mapBatchOperation(BatchOperationEntity source) {
        return new io.camunda.search.entities.BatchOperationEntity(source.getId(), BatchOperationEntity.BatchOperationState.valueOf((String)source.getState().name()), BatchOperationType.valueOf((String)source.getType().name()), source.getStartDate(), source.getEndDate(), source.getOperationsTotalCount(), source.getOperationsFailedCount(), source.getOperationsCompletedCount(), source.getErrors().stream().map(this::mapBatchOperationError).toList());
    }

    private BatchOperationEntity.BatchOperationErrorEntity mapBatchOperationError(BatchOperationErrorEntity source) {
        return new BatchOperationEntity.BatchOperationErrorEntity(Integer.valueOf(source.getPartitionId()), source.getType(), source.getMessage());
    }

    private io.camunda.search.entities.BatchOperationEntity mapLegacyBatchOperation(BatchOperationEntity source) {
        return new io.camunda.search.entities.BatchOperationEntity(source.getId(), source.getState() != null ? BatchOperationEntity.BatchOperationState.valueOf((String)source.getState().name()) : this.interpolateLegacyState(source), source.getType() != null ? BatchOperationType.valueOf((String)source.getType().name()) : null, source.getStartDate(), source.getEndDate(), source.getOperationsTotalCount(), Integer.valueOf(0), source.getOperationsFinishedCount(), Collections.emptyList());
    }

    private BatchOperationEntity.BatchOperationState interpolateLegacyState(BatchOperationEntity entity) {
        if (entity.getEndDate() != null) {
            return BatchOperationEntity.BatchOperationState.COMPLETED;
        }
        if (entity.getOperationsFinishedCount() == 0) {
            return BatchOperationEntity.BatchOperationState.CREATED;
        }
        return BatchOperationEntity.BatchOperationState.ACTIVE;
    }
}

