/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.aggregation.result;

import io.camunda.search.aggregation.result.UsageMetricsTUAggregationResult;
import io.camunda.search.clients.core.AggregationResult;
import io.camunda.search.clients.transformers.aggregation.result.AggregationResultTransformer;
import io.camunda.search.entities.UsageMetricTUStatisticsEntity;
import java.util.HashMap;
import java.util.Map;

public class UsageMetricsTUAggregationResultTransformer
implements AggregationResultTransformer<UsageMetricsTUAggregationResult> {
    @Override
    public UsageMetricsTUAggregationResult apply(Map<String, AggregationResult> aggregations) {
        UsageMetricTUStatisticsEntity res;
        boolean withTenants = aggregations.containsKey("termsTenantId");
        Long totalTu = aggregations.get("termsAssigneeHash").docCount();
        if (withTenants) {
            AggregationResult tenantsAgg = aggregations.get("termsTenantId");
            HashMap<String, UsageMetricTUStatisticsEntity.UsageMetricTUStatisticsEntityTenant> tenants = new HashMap<String, UsageMetricTUStatisticsEntity.UsageMetricTUStatisticsEntityTenant>(tenantsAgg.aggregations().size());
            for (Map.Entry<String, AggregationResult> entry : tenantsAgg.aggregations().entrySet()) {
                String tenantId = entry.getKey();
                AggregationResult tenantIdAgg = entry.getValue();
                long tenantTu = tenantIdAgg.aggregations().get("termsAssigneeHash").docCount();
                tenants.put(tenantId, new UsageMetricTUStatisticsEntity.UsageMetricTUStatisticsEntityTenant.Builder().tu(tenantTu).build());
            }
            res = new UsageMetricTUStatisticsEntity(totalTu.longValue(), tenants);
        } else {
            res = new UsageMetricTUStatisticsEntity(totalTu.longValue(), null);
        }
        return new UsageMetricsTUAggregationResult(res);
    }
}

