/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.aggregation.result;

import io.camunda.search.aggregation.result.UsageMetricsAggregationResult;
import io.camunda.search.clients.core.AggregationResult;
import io.camunda.search.clients.transformers.aggregation.result.AggregationResultTransformer;
import io.camunda.search.entities.UsageMetricStatisticsEntity;
import io.camunda.webapps.schema.entities.metrics.UsageMetricsEventType;
import java.util.HashMap;
import java.util.Map;

public class UsageMetricsAggregationResultTransformer
implements AggregationResultTransformer<UsageMetricsAggregationResult> {
    private long extractMetricCount(AggregationResult eventTypes, UsageMetricsEventType metricName) {
        AggregationResult metric = eventTypes.aggregations().get(metricName.name());
        if (metric != null) {
            return metric.aggregations().get("sumEventType").docCount();
        }
        return 0L;
    }

    @Override
    public UsageMetricsAggregationResult apply(Map<String, AggregationResult> aggregations) {
        UsageMetricStatisticsEntity res;
        boolean withTenants;
        boolean bl = withTenants = !aggregations.containsKey("termsEventType");
        if (withTenants) {
            AggregationResult tenantsAgg = aggregations.get("termsTenantId");
            long totalRpi = 0L;
            long totalEdi = 0L;
            HashMap<String, UsageMetricStatisticsEntity.UsageMetricStatisticsEntityTenant> tenants = new HashMap<String, UsageMetricStatisticsEntity.UsageMetricStatisticsEntityTenant>(tenantsAgg.aggregations().size());
            for (Map.Entry<String, AggregationResult> entry : tenantsAgg.aggregations().entrySet()) {
                String tenantId = entry.getKey();
                AggregationResult tenantIdAgg = entry.getValue();
                AggregationResult eventTypesAgg = tenantIdAgg.aggregations().get("termsEventType");
                long tenantRpi = this.extractMetricCount(eventTypesAgg, UsageMetricsEventType.RPI);
                long tenantEdi = this.extractMetricCount(eventTypesAgg, UsageMetricsEventType.EDI);
                totalRpi += tenantRpi;
                totalEdi += tenantEdi;
                tenants.put(tenantId, new UsageMetricStatisticsEntity.UsageMetricStatisticsEntityTenant.Builder().rpi(tenantRpi).edi(tenantEdi).build());
            }
            res = new UsageMetricStatisticsEntity(totalRpi, totalEdi, (long)tenants.size(), tenants);
        } else {
            AggregationResult eventTypesAgg = aggregations.get("termsEventType");
            long totalRpi = this.extractMetricCount(eventTypesAgg, UsageMetricsEventType.RPI);
            long totalEdi = this.extractMetricCount(eventTypesAgg, UsageMetricsEventType.EDI);
            AggregationResult tenantsAgg = aggregations.get("termsTenantId");
            int totalAt = tenantsAgg.aggregations().size();
            res = new UsageMetricStatisticsEntity(totalRpi, totalEdi, (long)totalAt, null);
        }
        return new UsageMetricsAggregationResult(res);
    }
}

