/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.aggregation.result;

import io.camunda.search.aggregation.result.ProcessDefinitionFlowNodeStatisticsAggregationResult;
import io.camunda.search.clients.core.AggregationResult;
import io.camunda.search.clients.transformers.aggregation.result.AggregationResultTransformer;
import io.camunda.search.entities.ProcessFlowNodeStatisticsEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class ProcessDefinitionFlowNodeStatisticsAggregationResultTransformer
implements AggregationResultTransformer<ProcessDefinitionFlowNodeStatisticsAggregationResult> {
    private void processFilter(AggregationResult aggregationResult, Map<String, ProcessFlowNodeStatisticsEntity.Builder> resultMap, BiConsumer<ProcessFlowNodeStatisticsEntity.Builder, Long> resultConsumer) {
        AggregationResult group = aggregationResult.aggregations().get("terms-flow-nodes");
        group.aggregations().forEach((flowNodeId, result) -> {
            AggregationResult parents = result.aggregations().get("parents-process-instances");
            ProcessFlowNodeStatisticsEntity.Builder entity = resultMap.getOrDefault(flowNodeId, new ProcessFlowNodeStatisticsEntity.Builder().flowNodeId(flowNodeId));
            resultConsumer.accept(entity, parents.docCount());
            resultMap.put((String)flowNodeId, entity);
        });
    }

    @Override
    public ProcessDefinitionFlowNodeStatisticsAggregationResult apply(Map<String, AggregationResult> aggregations) {
        HashMap<String, ProcessFlowNodeStatisticsEntity.Builder> entitiesMap = new HashMap<String, ProcessFlowNodeStatisticsEntity.Builder>();
        this.processFilter(aggregations.get("active"), entitiesMap, ProcessFlowNodeStatisticsEntity.Builder::active);
        this.processFilter(aggregations.get("completed"), entitiesMap, ProcessFlowNodeStatisticsEntity.Builder::completed);
        this.processFilter(aggregations.get("canceled"), entitiesMap, ProcessFlowNodeStatisticsEntity.Builder::canceled);
        this.processFilter(aggregations.get("incidents"), entitiesMap, ProcessFlowNodeStatisticsEntity.Builder::incidents);
        return new ProcessDefinitionFlowNodeStatisticsAggregationResult(entitiesMap.values().stream().map(ProcessFlowNodeStatisticsEntity.Builder::build).toList());
    }
}

