/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.aggregation;

import io.camunda.search.aggregation.ProcessDefinitionLatestVersionAggregation;
import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.clients.aggregator.SearchAggregatorBuilders;
import io.camunda.search.clients.aggregator.SearchCompositeAggregator;
import io.camunda.search.clients.aggregator.SearchTermsAggregator;
import io.camunda.search.clients.aggregator.SearchTopHitsAggregator;
import io.camunda.search.clients.transformers.ServiceTransformers;
import io.camunda.search.clients.transformers.aggregation.AggregationTransformer;
import io.camunda.search.page.SearchQueryPage;
import io.camunda.search.sort.ProcessDefinitionSort;
import io.camunda.search.sort.SortOption;
import io.camunda.webapps.schema.entities.ProcessEntity;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class ProcessDefinitionLatestVersionAggregationTransformer
implements AggregationTransformer<ProcessDefinitionLatestVersionAggregation> {
    @Override
    public List<SearchAggregator> apply(Tuple<ProcessDefinitionLatestVersionAggregation, ServiceTransformers> value) {
        ProcessDefinitionLatestVersionAggregation aggregation = (ProcessDefinitionLatestVersionAggregation)value.getLeft();
        ServiceTransformers transformers = (ServiceTransformers)value.getRight();
        SearchQueryPage page = aggregation.page();
        ProcessDefinitionSort sort = aggregation.sort();
        SearchTopHitsAggregator.Builder topHits = SearchAggregatorBuilders.topHits();
        Object maxVersionsAgg = ((SearchTopHitsAggregator.Builder)topHits.name("latest_definition")).field("version").documentClass(ProcessEntity.class).build();
        SearchTermsAggregator.Builder byProcessIdAggSourceBuilder = ((SearchTermsAggregator.Builder)SearchAggregatorBuilders.terms().name("bpmnProcessId")).field("bpmnProcessId");
        Optional.ofNullable(sort).map(ProcessDefinitionSort::orderings).map(this.getSortOptionFor("bpmnProcessId", transformers)).ifPresent(byProcessIdAggSourceBuilder::sorting);
        SearchTermsAggregator.Builder byTenantIdAggSourceBuilder = ((SearchTermsAggregator.Builder)SearchAggregatorBuilders.terms().name("tenantId")).field("tenantId");
        Optional.ofNullable(sort).map(ProcessDefinitionSort::orderings).map(this.getSortOptionFor("tenantId", transformers)).ifPresent(byTenantIdAggSourceBuilder::sorting);
        SearchCompositeAggregator finalAggregation = ((SearchCompositeAggregator.Builder)((SearchCompositeAggregator.Builder)SearchAggregatorBuilders.composite().name("by-process-id")).size(Optional.ofNullable(page).map(SearchQueryPage::size).orElse(10000)).after(Optional.ofNullable(page).map(SearchQueryPage::after).orElse(null)).sources(List.of(byProcessIdAggSourceBuilder.build(), byTenantIdAggSourceBuilder.build())).aggregations((SearchAggregator)maxVersionsAgg, new SearchAggregator[0])).build();
        return List.of(finalAggregation);
    }

    private Function<List<SortOption.FieldSorting>, List<SortOption.FieldSorting>> getSortOptionFor(String aggregationField, ServiceTransformers transformers) {
        return orderings -> orderings.stream().map(ordering -> new SortOption.FieldSorting(transformers.getFieldSortingTransformer(ProcessDefinitionSort.class).apply(ordering.field()), ordering.order())).filter(fs -> fs.field().equals(aggregationField)).toList();
    }
}

