/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.reader;

import io.camunda.search.clients.SearchClientBasedQueryExecutor;
import io.camunda.search.clients.reader.DocumentBasedReader;
import io.camunda.search.clients.reader.RoleReader;
import io.camunda.search.clients.reader.TenantMemberDocumentReader;
import io.camunda.search.entities.RoleEntity;
import io.camunda.search.query.RoleQuery;
import io.camunda.search.query.SearchQueryResult;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.util.ObjectBuilder;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.Set;

public class RoleDocumentReader
extends DocumentBasedReader
implements RoleReader {
    private final TenantMemberDocumentReader tenantMemberReader;

    public RoleDocumentReader(SearchClientBasedQueryExecutor executor, IndexDescriptor indexDescriptor, TenantMemberDocumentReader tenantMemberReader) {
        super(executor, indexDescriptor);
        this.tenantMemberReader = tenantMemberReader;
    }

    public RoleEntity getById(String id, ResourceAccessChecks resourceAccessChecks) {
        return (RoleEntity)this.getSearchExecutor().getByQuery(RoleQuery.of(b -> (ObjectBuilder)b.filter(f -> f.roleId(id)).singleResult()), io.camunda.webapps.schema.entities.usermanagement.RoleEntity.class);
    }

    public SearchQueryResult<RoleEntity> search(RoleQuery query, ResourceAccessChecks resourceAccessChecks) {
        RoleQuery roleQuery = query;
        if (query.filter().tenantId() != null) {
            roleQuery = this.expandTenantFilter(query);
        }
        return this.getSearchExecutor().search(roleQuery, io.camunda.webapps.schema.entities.usermanagement.RoleEntity.class, resourceAccessChecks);
    }

    private RoleQuery expandTenantFilter(RoleQuery query) {
        Set<String> roleIds = this.tenantMemberReader.getTenantMembers(query.filter().tenantId(), EntityType.ROLE);
        return query.toBuilder().filter(query.filter().toBuilder().roleIds(roleIds).build()).build();
    }
}

