/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.reader;

import io.camunda.search.aggregation.result.ProcessDefinitionFlowNodeStatisticsAggregationResult;
import io.camunda.search.clients.SearchClientBasedQueryExecutor;
import io.camunda.search.clients.reader.DocumentBasedReader;
import io.camunda.search.clients.reader.IncidentDocumentReader;
import io.camunda.search.clients.reader.ProcessDefinitionStatisticsReader;
import io.camunda.search.entities.ProcessFlowNodeStatisticsEntity;
import io.camunda.search.filter.Operation;
import io.camunda.search.filter.ProcessDefinitionStatisticsFilter;
import io.camunda.search.query.ProcessDefinitionFlowNodeStatisticsQuery;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.ArrayList;
import java.util.List;

public class ProcessDefinitionStatisticsDocumentReader
extends DocumentBasedReader
implements ProcessDefinitionStatisticsReader {
    private final IncidentDocumentReader incidentReader;

    public ProcessDefinitionStatisticsDocumentReader(SearchClientBasedQueryExecutor executor, IndexDescriptor indexDescriptor, IncidentDocumentReader incidentReader) {
        super(executor, indexDescriptor);
        this.incidentReader = incidentReader;
    }

    public List<ProcessFlowNodeStatisticsEntity> aggregate(ProcessDefinitionFlowNodeStatisticsQuery query, ResourceAccessChecks resourceAccessChecks) {
        ProcessDefinitionStatisticsFilter filter = query.filter();
        if (filter.incidentErrorHashCodeOperations() != null && !filter.incidentErrorHashCodeOperations().isEmpty() && ((filter = this.normalizePDTopLevelIncidentHashCodes(filter, resourceAccessChecks)).incidentErrorHashCodeOperations() == null || filter.errorMessageOperations().isEmpty())) {
            return List.of();
        }
        if (filter.orFilters() != null && !filter.orFilters().isEmpty()) {
            List<ProcessDefinitionStatisticsFilter> normalizedOr = this.normalizePDOrFilterErrorHashCodes(filter.orFilters(), resourceAccessChecks);
            if (normalizedOr.isEmpty()) {
                return List.of();
            }
            filter = filter.toBuilder().orFilters(normalizedOr).build();
        }
        return this.executeAggregate(new ProcessDefinitionFlowNodeStatisticsQuery(filter), resourceAccessChecks);
    }

    private List<ProcessFlowNodeStatisticsEntity> executeAggregate(ProcessDefinitionFlowNodeStatisticsQuery query, ResourceAccessChecks resourceAccessChecks) {
        return this.getSearchExecutor().aggregate(query, ProcessDefinitionFlowNodeStatisticsAggregationResult.class, resourceAccessChecks).items();
    }

    private ProcessDefinitionStatisticsFilter normalizePDTopLevelIncidentHashCodes(ProcessDefinitionStatisticsFilter filter, ResourceAccessChecks resourceAccessChecks) {
        if (filter.incidentErrorHashCodeOperations() == null || filter.incidentErrorHashCodeOperations().isEmpty()) {
            return filter;
        }
        String resolvedErrorMessage = this.incidentReader.findErrorMessageByErrorHashCodes(filter.incidentErrorHashCodeOperations(), resourceAccessChecks);
        if (resolvedErrorMessage == null || resolvedErrorMessage.isEmpty()) {
            return filter.toBuilder().incidentErrorHashCodeOperations(List.of()).build();
        }
        ArrayList<Operation> existingOps = filter.errorMessageOperations() != null ? new ArrayList<Operation>(filter.errorMessageOperations()) : new ArrayList();
        existingOps.add(Operation.eq((Object)resolvedErrorMessage));
        return filter.toBuilder().incidentErrorHashCodeOperations(null).replaceErrorMessageOperations(existingOps).build();
    }

    private List<ProcessDefinitionStatisticsFilter> normalizePDOrFilterErrorHashCodes(List<ProcessDefinitionStatisticsFilter> orFilters, ResourceAccessChecks resourceAccessChecks) {
        ArrayList<ProcessDefinitionStatisticsFilter> normalized = new ArrayList<ProcessDefinitionStatisticsFilter>();
        for (ProcessDefinitionStatisticsFilter subFilter : orFilters) {
            if (subFilter.incidentErrorHashCodeOperations() == null || subFilter.incidentErrorHashCodeOperations().isEmpty()) {
                normalized.add(subFilter);
                continue;
            }
            String resolvedErrorMessage = this.incidentReader.findErrorMessageByErrorHashCodes(subFilter.incidentErrorHashCodeOperations(), resourceAccessChecks);
            if (resolvedErrorMessage == null || resolvedErrorMessage.isBlank()) continue;
            ArrayList<Operation> existingOps = subFilter.errorMessageOperations() != null ? new ArrayList<Operation>(subFilter.errorMessageOperations()) : new ArrayList();
            existingOps.add(Operation.eq((Object)resolvedErrorMessage));
            ProcessDefinitionStatisticsFilter updatedSubFilter = subFilter.toBuilder().incidentErrorHashCodeOperations(null).replaceErrorMessageOperations(existingOps).build();
            normalized.add(updatedSubFilter);
        }
        return normalized;
    }
}

