/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.reader;

import io.camunda.search.clients.SearchClientBasedQueryExecutor;
import io.camunda.search.clients.reader.DocumentBasedReader;
import io.camunda.search.clients.reader.GroupMemberDocumentReader;
import io.camunda.search.clients.reader.MappingRuleReader;
import io.camunda.search.clients.reader.RoleMemberDocumentReader;
import io.camunda.search.clients.reader.TenantMemberDocumentReader;
import io.camunda.search.entities.MappingRuleEntity;
import io.camunda.search.query.MappingRuleQuery;
import io.camunda.search.query.SearchQueryResult;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.Set;

public class MappingRuleDocumentReader
extends DocumentBasedReader
implements MappingRuleReader {
    private final RoleMemberDocumentReader roleMemberReader;
    private final TenantMemberDocumentReader tenantMemberReader;
    private final GroupMemberDocumentReader groupMemberReader;

    public MappingRuleDocumentReader(SearchClientBasedQueryExecutor executor, IndexDescriptor indexDescriptor, RoleMemberDocumentReader roleMemberReader, TenantMemberDocumentReader tenantMemberReader, GroupMemberDocumentReader groupMemberReader) {
        super(executor, indexDescriptor);
        this.roleMemberReader = roleMemberReader;
        this.tenantMemberReader = tenantMemberReader;
        this.groupMemberReader = groupMemberReader;
    }

    public MappingRuleEntity getById(String id, ResourceAccessChecks resourceAccessChecks) {
        return (MappingRuleEntity)this.getSearchExecutor().getById(id, io.camunda.webapps.schema.entities.usermanagement.MappingRuleEntity.class, this.indexDescriptor.getFullQualifiedName());
    }

    public SearchQueryResult<MappingRuleEntity> search(MappingRuleQuery query, ResourceAccessChecks resourceAccessChecks) {
        return this.getSearchExecutor().search(this.applyFilters(query), io.camunda.webapps.schema.entities.usermanagement.MappingRuleEntity.class, resourceAccessChecks);
    }

    private MappingRuleQuery applyFilters(MappingRuleQuery mappingRuleQuery) {
        if (mappingRuleQuery.filter().tenantId() != null) {
            return this.expandTenantFilter(mappingRuleQuery);
        }
        if (mappingRuleQuery.filter().groupId() != null) {
            return this.expandGroupFilter(mappingRuleQuery);
        }
        if (mappingRuleQuery.filter().roleId() != null) {
            return this.expandRoleFilter(mappingRuleQuery);
        }
        return mappingRuleQuery;
    }

    private MappingRuleQuery expandTenantFilter(MappingRuleQuery query) {
        Set<String> mappingRuleIds = this.tenantMemberReader.getTenantMembers(query.filter().tenantId(), EntityType.MAPPING_RULE);
        return query.toBuilder().filter(query.filter().toBuilder().mappingRuleIds(mappingRuleIds).build()).build();
    }

    private MappingRuleQuery expandGroupFilter(MappingRuleQuery mappingRuleQuery) {
        Set<String> mappingRuleIds = this.groupMemberReader.getGroupMembers(mappingRuleQuery.filter().groupId(), EntityType.MAPPING_RULE);
        return mappingRuleQuery.toBuilder().filter(mappingRuleQuery.filter().toBuilder().mappingRuleIds(mappingRuleIds).build()).build();
    }

    private MappingRuleQuery expandRoleFilter(MappingRuleQuery query) {
        Set<String> mappingRuleIds = this.roleMemberReader.getRoleMembers(query.filter().roleId(), EntityType.MAPPING_RULE);
        return query.toBuilder().filter(query.filter().toBuilder().mappingRuleIds(mappingRuleIds).build()).build();
    }
}

