/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.reader;

import io.camunda.search.clients.SearchClientBasedQueryExecutor;
import io.camunda.search.clients.reader.DocumentBasedReader;
import io.camunda.search.clients.reader.IncidentReader;
import io.camunda.search.entities.IncidentEntity;
import io.camunda.search.filter.FilterBuilders;
import io.camunda.search.filter.IncidentFilter;
import io.camunda.search.filter.Operation;
import io.camunda.search.query.IncidentQuery;
import io.camunda.search.query.SearchQueryResult;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.util.ObjectBuilder;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.List;

public class IncidentDocumentReader
extends DocumentBasedReader
implements IncidentReader {
    public IncidentDocumentReader(SearchClientBasedQueryExecutor executor, IndexDescriptor indexDescriptor) {
        super(executor, indexDescriptor);
    }

    public IncidentEntity getByKey(long key, ResourceAccessChecks resourceAccessChecks) {
        return (IncidentEntity)this.getSearchExecutor().getByQuery(IncidentQuery.of(b -> (ObjectBuilder)b.filter(f -> f.incidentKeys(Long.valueOf(key), new Long[0])).singleResult()), io.camunda.webapps.schema.entities.incident.IncidentEntity.class);
    }

    public SearchQueryResult<IncidentEntity> search(IncidentQuery query, ResourceAccessChecks resourceAccessChecks) {
        return this.getSearchExecutor().search(query, io.camunda.webapps.schema.entities.incident.IncidentEntity.class, resourceAccessChecks);
    }

    public String findErrorMessageByErrorHashCodes(List<Operation<Integer>> hashCodeOperations, ResourceAccessChecks resourceAccessChecks) {
        if (hashCodeOperations == null || hashCodeOperations.isEmpty()) {
            return null;
        }
        IncidentFilter incidentFilter = FilterBuilders.incident(f -> f.errorMessageHashOperations(hashCodeOperations));
        SearchQueryResult<IncidentEntity> incidentResult = this.search(IncidentQuery.of(f -> f.filter(incidentFilter)), resourceAccessChecks);
        if (incidentResult.items().isEmpty()) {
            return null;
        }
        IncidentEntity incident = (IncidentEntity)incidentResult.items().getFirst();
        if (incident.errorMessage() == null || incident.errorMessage().isBlank()) {
            return null;
        }
        return incident.errorMessage();
    }
}

