/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.reader;

import io.camunda.search.clients.SearchClientBasedQueryExecutor;
import io.camunda.search.clients.reader.DocumentBasedReader;
import io.camunda.search.clients.reader.GroupReader;
import io.camunda.search.clients.reader.RoleMemberDocumentReader;
import io.camunda.search.clients.reader.TenantMemberDocumentReader;
import io.camunda.search.entities.GroupEntity;
import io.camunda.search.query.GroupQuery;
import io.camunda.search.query.SearchQueryResult;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.util.ObjectBuilder;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.Set;

public class GroupDocumentReader
extends DocumentBasedReader
implements GroupReader {
    private final TenantMemberDocumentReader tenantMemberReader;
    private final RoleMemberDocumentReader roleMemberReader;

    public GroupDocumentReader(SearchClientBasedQueryExecutor executor, IndexDescriptor indexDescriptor, TenantMemberDocumentReader tenantMemberReader, RoleMemberDocumentReader roleMemberReader) {
        super(executor, indexDescriptor);
        this.tenantMemberReader = tenantMemberReader;
        this.roleMemberReader = roleMemberReader;
    }

    public GroupEntity getById(String id, ResourceAccessChecks resourceAccessChecks) {
        return (GroupEntity)this.getSearchExecutor().getByQuery(GroupQuery.of(b -> (ObjectBuilder)b.filter(f -> f.groupIds(id, new String[0])).singleResult()), io.camunda.webapps.schema.entities.usermanagement.GroupEntity.class);
    }

    public SearchQueryResult<GroupEntity> search(GroupQuery query, ResourceAccessChecks resourceAccessChecks) {
        GroupQuery groupQuery = query;
        if (query.filter().tenantId() != null) {
            groupQuery = this.expandTenantFilter(query);
        }
        if (query.filter().roleId() != null) {
            groupQuery = this.expandRoleFilter(query);
        }
        return this.getSearchExecutor().search(groupQuery, io.camunda.webapps.schema.entities.usermanagement.GroupEntity.class, resourceAccessChecks);
    }

    private GroupQuery expandTenantFilter(GroupQuery query) {
        Set<String> groupIds = this.tenantMemberReader.getTenantMembers(query.filter().tenantId(), EntityType.GROUP);
        return query.toBuilder().filter(query.filter().toBuilder().groupIds(groupIds).build()).build();
    }

    private GroupQuery expandRoleFilter(GroupQuery query) {
        Set<String> groupIds = this.roleMemberReader.getRoleMembers(query.filter().roleId(), EntityType.GROUP);
        return query.toBuilder().filter(query.filter().toBuilder().groupIds(groupIds).build()).build();
    }
}

