/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.query;

import io.camunda.search.clients.query.SearchQueryOption;
import io.camunda.search.clients.types.TypedValue;
import io.camunda.util.ObjectBuilder;
import java.util.Objects;

public record SearchTermQuery(String field, TypedValue value, Boolean caseInsensitive) implements SearchQueryOption
{

    public static final class Builder
    implements ObjectBuilder<SearchTermQuery> {
        private String field;
        private TypedValue value;
        private Boolean caseInsensitive;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder value(String value) {
            return this.value(TypedValue.of(value));
        }

        public Builder value(short value) {
            return this.value(TypedValue.of(value));
        }

        public Builder value(int value) {
            return this.value(TypedValue.of(value));
        }

        public Builder value(long value) {
            return this.value(TypedValue.of(value));
        }

        public Builder value(double value) {
            return this.value(TypedValue.of(value));
        }

        public Builder value(boolean value) {
            return this.value(TypedValue.of(value));
        }

        public Builder value(TypedValue value) {
            this.value = value;
            return this;
        }

        public Builder caseInsensitive(Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        public SearchTermQuery build() {
            return new SearchTermQuery(Objects.requireNonNull(this.field, "Expected non-null field for term query."), Objects.requireNonNull(this.value, () -> String.format("Expected non-null value for term query, for field '%s'.", this.field)), this.caseInsensitive);
        }
    }
}

