/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.query;

import io.camunda.search.clients.query.SearchBoolQuery;
import io.camunda.search.clients.query.SearchConstantScoreQuery;
import io.camunda.search.clients.query.SearchExistsQuery;
import io.camunda.search.clients.query.SearchHasChildQuery;
import io.camunda.search.clients.query.SearchHasParentQuery;
import io.camunda.search.clients.query.SearchIdsQuery;
import io.camunda.search.clients.query.SearchMatchAllQuery;
import io.camunda.search.clients.query.SearchMatchNoneQuery;
import io.camunda.search.clients.query.SearchMatchQuery;
import io.camunda.search.clients.query.SearchPrefixQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.query.SearchQueryOption;
import io.camunda.search.clients.query.SearchRangeQuery;
import io.camunda.search.clients.query.SearchTermQuery;
import io.camunda.search.clients.query.SearchTermsQuery;
import io.camunda.search.clients.query.SearchWildcardQuery;
import io.camunda.util.ObjectBuilder;
import java.util.function.Function;

public record SearchQuery(SearchQueryOption queryOption) {
    public static SearchQuery of(Function<Builder, ObjectBuilder<SearchQuery>> fn) {
        return SearchQueryBuilders.query(fn);
    }

    public static final class Builder
    implements ObjectBuilder<SearchQuery> {
        private SearchQueryOption queryOption;

        public Builder bool(SearchBoolQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder bool(Function<SearchBoolQuery.Builder, ObjectBuilder<SearchBoolQuery>> fn) {
            return this.bool(SearchQueryBuilders.bool(fn));
        }

        public Builder constantScore(SearchConstantScoreQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder constantScore(Function<SearchConstantScoreQuery.Builder, ObjectBuilder<SearchConstantScoreQuery>> fn) {
            return this.constantScore(SearchQueryBuilders.constantScore(fn));
        }

        public Builder exists(SearchExistsQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder exists(Function<SearchExistsQuery.Builder, ObjectBuilder<SearchExistsQuery>> fn) {
            return this.exists(SearchQueryBuilders.exists(fn));
        }

        public Builder hasChild(SearchHasChildQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder hasChild(Function<SearchHasChildQuery.Builder, ObjectBuilder<SearchHasChildQuery>> fn) {
            return this.hasChild(SearchQueryBuilders.hasChild(fn));
        }

        public Builder ids(SearchIdsQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder ids(Function<SearchIdsQuery.Builder, ObjectBuilder<SearchIdsQuery>> fn) {
            return this.ids(SearchQueryBuilders.ids(fn));
        }

        public Builder match(SearchMatchQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder match(Function<SearchMatchQuery.Builder, ObjectBuilder<SearchMatchQuery>> fn) {
            return this.match(SearchQueryBuilders.match(fn));
        }

        public Builder matchAll() {
            this.queryOption = new SearchMatchAllQuery.Builder().build();
            return this;
        }

        public Builder matchNone(SearchMatchNoneQuery query) {
            this.queryOption = new SearchMatchNoneQuery.Builder().build();
            return this;
        }

        public Builder prefix(SearchPrefixQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder prefix(Function<SearchPrefixQuery.Builder, ObjectBuilder<SearchPrefixQuery>> fn) {
            return this.prefix(SearchQueryBuilders.prefix(fn));
        }

        public Builder range(SearchRangeQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder range(Function<SearchRangeQuery.Builder, ObjectBuilder<SearchRangeQuery>> fn) {
            return this.range(SearchQueryBuilders.range(fn));
        }

        public Builder term(SearchTermQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder term(Function<SearchTermQuery.Builder, ObjectBuilder<SearchTermQuery>> fn) {
            return this.term(SearchQueryBuilders.term(fn));
        }

        public Builder terms(SearchTermsQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder terms(Function<SearchTermsQuery.Builder, ObjectBuilder<SearchTermsQuery>> fn) {
            return this.terms(SearchQueryBuilders.terms(fn));
        }

        public Builder wildcard(SearchWildcardQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder wildcard(Function<SearchWildcardQuery.Builder, ObjectBuilder<SearchWildcardQuery>> fn) {
            return this.wildcard(SearchQueryBuilders.wildcard(fn));
        }

        public Builder hasParent(SearchHasParentQuery query) {
            this.queryOption = query;
            return this;
        }

        public Builder hasParent(Function<SearchHasParentQuery.Builder, ObjectBuilder<SearchHasParentQuery>> fn) {
            return this.hasParent(SearchQueryBuilders.hasParent(fn));
        }

        public SearchQuery build() {
            return new SearchQuery(this.queryOption);
        }
    }
}

