/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.query;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryOption;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public record SearchBoolQuery(List<SearchQuery> filter, List<SearchQuery> must, List<SearchQuery> mustNot, List<SearchQuery> should) implements SearchQueryOption
{

    public static final class Builder
    implements ObjectBuilder<SearchBoolQuery> {
        private List<SearchQuery> filter;
        private List<SearchQuery> must;
        private List<SearchQuery> mustNot;
        private List<SearchQuery> should;

        public Builder filter(List<SearchQuery> queries) {
            this.filter = CollectionUtil.addValuesToList(this.filter, queries);
            return this;
        }

        public Builder must(List<SearchQuery> queries) {
            this.must = CollectionUtil.addValuesToList(this.must, queries);
            return this;
        }

        public Builder mustNot(List<SearchQuery> queries) {
            this.mustNot = CollectionUtil.addValuesToList(this.mustNot, queries);
            return this;
        }

        public Builder should(List<SearchQuery> queries) {
            this.should = CollectionUtil.addValuesToList(this.should, queries);
            return this;
        }

        public SearchBoolQuery build() {
            return new SearchBoolQuery(Objects.requireNonNullElse(this.filter, Collections.emptyList()), Objects.requireNonNullElse(this.must, Collections.emptyList()), Objects.requireNonNullElse(this.mustNot, Collections.emptyList()), Objects.requireNonNullElse(this.should, Collections.emptyList()));
        }
    }
}

