/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.core;

import io.camunda.search.clients.core.RequestBuilders;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public record SearchGetRequest(String id, String index, String routing, List<String> sourceExcludes) {
    public static SearchGetRequest of(Function<Builder, ObjectBuilder<SearchGetRequest>> fn) {
        return RequestBuilders.getRequest(fn);
    }

    public static final class Builder
    implements ObjectBuilder<SearchGetRequest> {
        private String id;
        private String index;
        private String routing;
        private List<String> sourceExcludes;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder routing(String value) {
            this.routing = value;
            return this;
        }

        public Builder sourceExcludes(List<String> values) {
            this.sourceExcludes = CollectionUtil.addValuesToList(this.sourceExcludes, values);
            return this;
        }

        public SearchGetRequest build() {
            return new SearchGetRequest(Objects.requireNonNull(this.id, "Expected to retrieve a document by id, but given id was null."), Objects.requireNonNull(this.index, "Expected to create request for index, but given index was null."), this.routing, this.sourceExcludes);
        }
    }
}

